/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systests.cdi.base.jetty;

import jakarta.servlet.Servlet;
import java.util.EventListener;
import org.apache.cxf.cdi.CXFCdiServlet;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.junit.Assert;

public abstract class AbstractJettyServer
extends AbstractBusTestServerBase {
    private Server server;
    private final String resourcePath;
    private final String contextPath;
    private final int port;
    private final EventListener listener;

    protected AbstractJettyServer(String contextPath, int portNumber, EventListener listener) {
        this(null, contextPath, portNumber, listener);
    }

    protected AbstractJettyServer(String resourcePath, String contextPath, int portNumber, EventListener listener) {
        this.resourcePath = resourcePath;
        this.contextPath = contextPath;
        this.port = portNumber;
        this.listener = listener;
    }

    protected void run() {
        System.setProperty("java.naming.factory.url", "org.eclipse.jetty.jndi");
        System.setProperty("java.naming.factory.initial", "org.eclipse.jetty.jndi.InitialContextFactory");
        this.server = new Server(this.port);
        try {
            if (this.resourcePath == null) {
                ServletHolder servletHolder = new ServletHolder((Servlet)new CXFCdiServlet());
                ServletContextHandler context = new ServletContextHandler();
                context.setContextPath(this.contextPath);
                context.addEventListener(this.listener);
                context.addServlet(servletHolder, "/rest/*");
                this.server.setHandler((Handler)context);
            } else {
                WebAppContext context = new WebAppContext();
                context.setContextPath(this.contextPath);
                context.setBaseResourceAsString(((Object)((Object)this)).getClass().getResource(this.resourcePath).toString());
                WebAppContext.addServerClasses((Server)this.server, (String[])new String[]{"org.eclipse.jetty.servlet.ServletContextHandler.Decorator"});
                Handler.Sequence handlers = new Handler.Sequence(new Handler[0]);
                handlers.setHandlers(new Handler[]{context, new DefaultHandler()});
                this.server.setHandler((Handler)handlers);
            }
            this.server.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.server != null) {
            this.server.stop();
            this.server.destroy();
            this.server = null;
        }
    }
}

