/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systests.cdi.base;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.systests.cdi.base.AtomFeed;
import org.apache.cxf.systests.cdi.base.AtomFeedEntry;

@Produces(value={"application/atom+xml", "application/atom+xml;type=feed", "application/json"})
@Consumes(value={"application/atom+xml", "application/atom+xml;type=feed"})
@Provider
public class AtomFeedProvider
implements MessageBodyWriter<AtomFeed> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return AtomFeed.class.isAssignableFrom(type);
    }

    public void writeTo(AtomFeed t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        XMLStreamWriter writer = StaxUtils.createXMLStreamWriter((OutputStream)entityStream);
        try {
            writer.writeStartDocument();
            writer.writeStartElement("feed");
            if (t.getId() != null) {
                writer.writeAttribute("id", t.getId());
            }
            if (t.getLanguage() != null) {
                writer.writeAttribute("language", t.getLanguage());
            }
            writer.writeStartElement("entries");
            for (AtomFeedEntry entry : t.getEntries()) {
                writer.writeStartElement("entry");
                if (entry.getLink() != null) {
                    writer.writeAttribute("link", entry.getLink());
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex);
        }
        finally {
            try {
                writer.close();
            }
            catch (XMLStreamException ex) {
                throw new IOException(ex);
            }
        }
    }
}

