/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systests.cdi.base.tomcat;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.catalina.startup.Tomcat;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.junit.Assert;

public abstract class AbstractTomcatServer
extends AbstractBusTestServerBase {
    private final String resourcePath;
    private final String contextPath;
    private final int port;
    private Tomcat server;
    private Path base;

    protected AbstractTomcatServer(String resourcePath, String contextPath, int portNumber) {
        this.resourcePath = resourcePath;
        this.contextPath = contextPath;
        this.port = portNumber;
    }

    protected void run() {
        System.setProperty("java.naming.factory.url", "org.eclipse.jetty.jndi");
        System.setProperty("java.naming.factory.initial", "org.eclipse.jetty.jndi.InitialContextFactory");
        this.server = new Tomcat();
        this.server.setPort(this.port);
        this.server.getConnector();
        try {
            this.base = Files.createTempDirectory("tmp-", new FileAttribute[0]);
            this.server.setBaseDir(this.base.toString());
            this.server.getHost().setAppBase(this.base.toString());
            this.server.getHost().setAutoDeploy(true);
            this.server.getHost().setDeployOnStartup(true);
            this.server.addWebapp(this.contextPath, ((Object)((Object)this)).getClass().getResource(this.resourcePath).toURI().getPath());
            this.server.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.server != null) {
            this.server.stop();
            this.server.destroy();
            this.server = null;
            FileUtils.removeDir((File)this.base.toFile());
        }
    }
}

