/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systests.cdi.base;

import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.message.Message;
import org.apache.cxf.systests.cdi.base.Book;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractCdiSingleAppTest
extends AbstractBusClientServerTestBase {
    @Test
    public void testAvailableInjections() {
        Assert.assertEquals((Object)"configuration=Configuration/contextResolver=ContextResolver/cxfApplication=Application/cxfConfiguration=Configuration/cxfContextResolver=ContextResolver/cxfHttpHeaders=HttpHeaders/cxfHttpServletRequest=HttpServletRequest/cxfProviders=Providers/cxfRequest=Request/cxfResourceContext=ResourceContext/cxfResourceInfo=ResourceInfo/cxfSecurityContext=SecurityContext/cxfServletContext=ServletContext/cxfUriInfo=UriInfo/cxfhttpServletResponse=HttpServletRequest/httpHeaders=HttpHeaders/httpServletRequest=HttpServletRequest/httpServletResponse=HttpServletResponse/providers=Providers/request=Request/resourceContext=ResourceContext/resourceInfo=ResourceInfo/securityContext=SecurityContext/servletContext=ServletContext/uriInfo=UriInfo", (Object)((String)this.createWebClient(this.getBasePath() + "/injections", "text/plain").get(String.class)).trim());
    }

    @Test
    public void testInjectedVersionIsProperlyReturned() {
        Response r = this.createWebClient(this.getBasePath() + "/version", "text/plain").get();
        String pathInfo = r.getHeaderString(Message.PATH_INFO);
        String httpMethod = r.getHeaderString("org.apache.cxf.request.method");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Assert.assertEquals((Object)"1.0", (Object)r.readEntity(String.class));
        Assert.assertTrue((boolean)pathInfo.endsWith("/bookstore/version"));
        Assert.assertEquals((Object)"GET", (Object)httpMethod);
    }

    @Test
    public void testResponseHasBeenReceivedWhenAddingNewBook() {
        Response r = this.createWebClient(this.getBasePath() + "/books").post((Object)new Form().param("id", "1234").param("name", "Book 1234"));
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testResponseHasBeenReceivedWhenQueringAllBooks() {
        Response r = this.createWebClient(this.getBasePath() + "/books").get();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testResponseHasBeenReceivedWhenQueringBooksById() {
        String id = UUID.randomUUID().toString();
        Response r = this.createWebClient(this.getBasePath() + "/books").post((Object)new Form().param("id", id).param("name", "Book " + id));
        r.close();
        r = this.createWebClient(this.getBasePath() + "/byIds").query("ids", new Object[]{"1234"}).query("ids", new Object[]{UUID.randomUUID().toString()}).query("ids", new Object[]{id}).get();
        r.close();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
    }

    @Test
    public void testAddAndQueryOneBook() {
        String id = UUID.randomUUID().toString();
        Response r = this.createWebClient(this.getBasePath() + "/books").post((Object)new Form().param("id", id).param("name", "Book 1234"));
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)r.getStatus());
        r = this.createWebClient(this.getBasePath() + "/books").path((Object)id).get();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Book book = (Book)r.readEntity(Book.class);
        Assert.assertEquals((Object)id, (Object)book.getId());
    }

    protected WebClient createWebClient(String url) {
        return this.createWebClient(url, "application/json");
    }

    protected WebClient createWebClient(String url, String mediaType) {
        List<JacksonJsonProvider> providers = Arrays.asList(new JacksonJsonProvider());
        WebClient wc = WebClient.create((String)("http://localhost:" + this.getPort() + url), providers).accept(new String[]{mediaType});
        WebClient.getConfig((Object)wc).getHttpConduit().getClient().setReceiveTimeout(10000000L);
        return wc;
    }

    protected String getBasePath() {
        return "/rest/bookstore";
    }

    protected abstract int getPort();
}

