/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systests.cdi.base.jetty;

import java.util.EventListener;
import javax.servlet.Servlet;
import org.apache.cxf.cdi.CXFCdiServlet;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.junit.Assert;

public abstract class AbstractJettyServer
extends AbstractBusTestServerBase {
    private Server server;
    private final String resourcePath;
    private final String contextPath;
    private final int port;
    private final EventListener listener;

    protected AbstractJettyServer(String contextPath, int portNumber, EventListener listener) {
        this(null, contextPath, portNumber, listener);
    }

    protected AbstractJettyServer(String resourcePath, String contextPath, int portNumber, EventListener listener) {
        this.resourcePath = resourcePath;
        this.contextPath = contextPath;
        this.port = portNumber;
        this.listener = listener;
    }

    protected void run() {
        System.setProperty("java.naming.factory.url", "org.eclipse.jetty.jndi");
        System.setProperty("java.naming.factory.initial", "org.eclipse.jetty.jndi.InitialContextFactory");
        this.server = new Server(this.port);
        try {
            if (this.resourcePath == null) {
                ServletHolder servletHolder = new ServletHolder((Servlet)new CXFCdiServlet());
                ServletContextHandler context = new ServletContextHandler();
                context.setContextPath(this.contextPath);
                context.addEventListener(this.listener);
                context.addServlet(servletHolder, "/rest/*");
                this.server.setHandler((Handler)context);
            } else {
                WebAppContext context = new WebAppContext();
                context.setContextPath(this.contextPath);
                context.setBaseResource(Resource.newClassPathResource((String)this.resourcePath));
                context.setServerClasses(new String[]{"org.eclipse.jetty.servlet.ServletContextHandler.Decorator"});
                HandlerCollection handlers = new HandlerCollection();
                handlers.setHandlers(new Handler[]{context, new DefaultHandler()});
                this.server.setHandler((Handler)handlers);
            }
            this.server.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.server != null) {
            this.server.stop();
            this.server.destroy();
            this.server = null;
        }
    }
}

