/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xkms.x509.handlers;

import jakarta.xml.bind.JAXBElement;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.xkms.exception.XKMSCertificateException;
import org.apache.cxf.xkms.exception.XKMSException;
import org.apache.cxf.xkms.handlers.Applications;
import org.apache.cxf.xkms.handlers.Locator;
import org.apache.cxf.xkms.model.xkms.LocateRequestType;
import org.apache.cxf.xkms.model.xkms.QueryKeyBindingType;
import org.apache.cxf.xkms.model.xkms.ResultMajorEnum;
import org.apache.cxf.xkms.model.xkms.ResultMinorEnum;
import org.apache.cxf.xkms.model.xkms.UnverifiedKeyBindingType;
import org.apache.cxf.xkms.model.xkms.UseKeyWithType;
import org.apache.cxf.xkms.model.xmldsig.KeyInfoType;
import org.apache.cxf.xkms.model.xmldsig.X509DataType;
import org.apache.cxf.xkms.model.xmldsig.X509IssuerSerialType;
import org.apache.cxf.xkms.x509.repo.CertificateRepo;
import org.apache.cxf.xkms.x509.utils.X509Utils;

public class X509Locator
implements Locator {
    private CertificateRepo certRepo;

    public X509Locator(CertificateRepo certRepo) throws CertificateException {
        this.certRepo = certRepo;
    }

    public UnverifiedKeyBindingType locate(LocateRequestType request) {
        List<UseKeyWithType> keyIDs = this.parse(request);
        try {
            X509Certificate cert = this.findCertificate(keyIDs);
            if (cert == null) {
                return null;
            }
            UnverifiedKeyBindingType result = new UnverifiedKeyBindingType();
            result.setKeyInfo(X509Utils.getKeyInfo(cert));
            return result;
        }
        catch (CertificateEncodingException e) {
            throw new XKMSCertificateException("Cannot encode certificate: " + e.getMessage(), (Throwable)e);
        }
        catch (CertificateException e1) {
            throw new XKMSCertificateException(e1.getMessage(), (Throwable)e1);
        }
    }

    public X509Certificate findCertificate(List<UseKeyWithType> ids) throws CertificateException {
        X509Certificate cert = null;
        if (ids.isEmpty()) {
            throw new IllegalArgumentException("No UseKeyWithType elements found");
        }
        if (ids.size() == 1) {
            Applications application = Applications.fromUri((String)ids.get(0).getApplication());
            String id = ids.get(0).getIdentifier();
            if (application == Applications.PKIX) {
                cert = this.certRepo.findBySubjectDn(id);
            } else if (application == Applications.SERVICE_NAME) {
                cert = this.certRepo.findByServiceName(id);
            } else if (application == Applications.SERVICE_ENDPOINT) {
                cert = this.certRepo.findByEndpoint(id);
            }
        }
        String issuer = this.getIdForApplication(Applications.ISSUER, ids);
        String serial = this.getIdForApplication(Applications.SERIAL, ids);
        if (issuer != null && serial != null) {
            cert = this.certRepo.findByIssuerSerial(issuer, serial);
        }
        return cert;
    }

    private String getIdForApplication(Applications application, List<UseKeyWithType> ids) {
        for (UseKeyWithType id : ids) {
            if (!application.getUri().equalsIgnoreCase(id.getApplication())) continue;
            return id.getIdentifier();
        }
        return null;
    }

    private List<UseKeyWithType> parse(LocateRequestType request) {
        ArrayList<UseKeyWithType> keyIDs = new ArrayList<UseKeyWithType>();
        if (request == null) {
            return keyIDs;
        }
        QueryKeyBindingType query = request.getQueryKeyBinding();
        if (query == null) {
            return keyIDs;
        }
        if (query.getTimeInstant() != null) {
            throw new XKMSException(ResultMajorEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_RECEIVER, ResultMinorEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_TIME_INSTANT_NOT_SUPPORTED);
        }
        keyIDs.addAll(this.parse(query.getKeyInfo()));
        List useKeyList = query.getUseKeyWith();
        keyIDs.addAll(useKeyList);
        return keyIDs;
    }

    private List<UseKeyWithType> parse(KeyInfoType keyInfo) {
        ArrayList<UseKeyWithType> keyIDs = new ArrayList<UseKeyWithType>();
        if (keyInfo == null) {
            return keyIDs;
        }
        List content = keyInfo.getContent();
        for (Object obj1 : content) {
            if (!(obj1 instanceof JAXBElement)) continue;
            JAXBElement keyInfoChild = (JAXBElement)obj1;
            if (X509Utils.X509_KEY_NAME.equals(keyInfoChild.getName())) {
                UseKeyWithType keyDN = new UseKeyWithType();
                keyDN.setApplication(Applications.PKIX.getUri());
                keyDN.setIdentifier((String)keyInfoChild.getValue());
                keyIDs.add(keyDN);
                continue;
            }
            if (!X509Utils.X509_DATA.equals(keyInfoChild.getName())) continue;
            X509DataType x509Data = (X509DataType)keyInfoChild.getValue();
            List x509DataContent = x509Data.getX509IssuerSerialOrX509SKIOrX509SubjectName();
            for (Object obj2 : x509DataContent) {
                if (!(obj2 instanceof JAXBElement)) continue;
                JAXBElement x509DataChild = (JAXBElement)obj2;
                if (X509Utils.X509_ISSUER_SERIAL.equals(x509DataChild.getName())) {
                    X509IssuerSerialType x509IssuerSerial = (X509IssuerSerialType)x509DataChild.getValue();
                    UseKeyWithType issuer = new UseKeyWithType();
                    issuer.setApplication(Applications.ISSUER.getUri());
                    issuer.setIdentifier(x509IssuerSerial.getX509IssuerName());
                    keyIDs.add(issuer);
                    UseKeyWithType serial = new UseKeyWithType();
                    serial.setApplication(Applications.SERIAL.getUri());
                    serial.setIdentifier(x509IssuerSerial.getX509SerialNumber().toString());
                    keyIDs.add(serial);
                    continue;
                }
                if (!X509Utils.X509_SUBJECT_NAME.equals(x509DataChild.getName())) continue;
                UseKeyWithType keyDN = new UseKeyWithType();
                keyDN.setApplication(Applications.PKIX.getUri());
                keyDN.setIdentifier((String)x509DataChild.getValue());
                keyIDs.add(keyDN);
            }
        }
        return keyIDs;
    }
}

