/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xkms.handlers;

public final class DnUtils {
    private DnUtils() {
    }

    public static String extractMostSignificantAttribute(String identifier) {
        String[] split = identifier.split(",");
        String msaVal = null;
        String cnVal = null;
        String ouVal = null;
        for (String val : split) {
            val = DnUtils.normalizeAttribute(val);
            if (null == msaVal) {
                msaVal = val;
            }
            if (cnVal == null && val.startsWith("cn=")) {
                cnVal = val;
            }
            if (ouVal != null || !val.startsWith("ou=")) continue;
            ouVal = val;
        }
        if (cnVal != null) {
            return cnVal;
        }
        if (ouVal != null) {
            return ouVal;
        }
        return msaVal;
    }

    public static String extractMostSignificantAttributeValue(String identifier) {
        String attr = DnUtils.extractMostSignificantAttribute(identifier);
        if (attr != null) {
            String[] split = attr.split("=");
            if (split.length == 2) {
                return split[1].trim();
            }
            return attr.trim();
        }
        return attr;
    }

    private static String normalizeAttribute(String val) {
        Object normalized = val;
        if (null != val) {
            String[] split = val.split("=");
            if (split.length == 2) {
                String prefix = split[0].toLowerCase().trim();
                String value = split[1].trim();
                normalized = prefix + "=" + value;
            } else {
                normalized = val.trim();
            }
        }
        return normalized;
    }

    public static class DnAttribute {
        private String prefix;
        private String name;
        private String full;

        public DnAttribute(String attributeDefinition) {
            this.full = attributeDefinition;
            String[] split = attributeDefinition.split("=");
            if (1 == split.length) {
                this.name = split[0];
            } else if (2 == split.length) {
                this.prefix = split[0];
                this.name = split[1];
            }
        }

        public String prefix() {
            return this.prefix;
        }

        public String name() {
            return this.name;
        }

        public String full() {
            return this.full;
        }

        public String toString() {
            return this.full;
        }
    }
}

