/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xkms.crypto.impl;

import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.xkms.cache.EHCacheXKMSClientCache;
import org.apache.cxf.xkms.cache.XKMSCacheToken;
import org.apache.cxf.xkms.cache.XKMSClientCache;
import org.apache.cxf.xkms.crypto.CryptoProviderException;
import org.apache.cxf.xkms.crypto.impl.XKMSInvoker;
import org.apache.cxf.xkms.handlers.Applications;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoBase;
import org.apache.ws.security.components.crypto.CryptoType;
import org.w3._2002._03.xkms_wsdl.XKMSPortType;

public class XkmsCryptoProvider
extends CryptoBase {
    private static final Logger LOG = LogUtils.getL7dLogger(XkmsCryptoProvider.class);
    private final XKMSInvoker xkmsInvoker;
    private Crypto fallbackCrypto;
    private XKMSClientCache xkmsClientCache;
    private boolean allowX509FromJKS = true;

    public XkmsCryptoProvider(XKMSPortType xkmsConsumer) {
        this(xkmsConsumer, null);
    }

    public XkmsCryptoProvider(XKMSPortType xkmsConsumer, Crypto fallbackCrypto) {
        this(xkmsConsumer, fallbackCrypto, new EHCacheXKMSClientCache(), true);
    }

    public XkmsCryptoProvider(XKMSPortType xkmsConsumer, Crypto fallbackCrypto, boolean allowX509FromJKS) {
        this(xkmsConsumer, fallbackCrypto, new EHCacheXKMSClientCache(), allowX509FromJKS);
    }

    public XkmsCryptoProvider(XKMSPortType xkmsConsumer, Crypto fallbackCrypto, XKMSClientCache xkmsClientCache, boolean allowX509FromJKS) {
        if (xkmsConsumer == null) {
            throw new IllegalArgumentException("xkmsConsumer may not be null");
        }
        this.xkmsInvoker = new XKMSInvoker(xkmsConsumer);
        this.fallbackCrypto = fallbackCrypto;
        this.xkmsClientCache = xkmsClientCache;
        this.allowX509FromJKS = allowX509FromJKS;
    }

    public X509Certificate[] getX509Certificates(CryptoType cryptoType) throws WSSecurityException {
        X509Certificate[] certs;
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info(String.format("XKMS Runtime: getting public certificate for alias: %s; issuer: %s; subjectDN: %s", cryptoType.getAlias(), cryptoType.getIssuer(), cryptoType.getSubjectDN()));
        }
        if ((certs = this.getX509(cryptoType)) == null) {
            LOG.warning(String.format("Cannot find certificate for alias: %s, issuer: %s; subjectDN: %s", cryptoType.getAlias(), cryptoType.getIssuer(), cryptoType.getSubjectDN()));
        }
        return certs;
    }

    public String getX509Identifier(X509Certificate cert) throws WSSecurityException {
        this.assertDefaultCryptoProvider();
        return this.fallbackCrypto.getX509Identifier(cert);
    }

    public PrivateKey getPrivateKey(X509Certificate certificate, CallbackHandler callbackHandler) throws WSSecurityException {
        this.assertDefaultCryptoProvider();
        return this.fallbackCrypto.getPrivateKey(certificate, callbackHandler);
    }

    public PrivateKey getPrivateKey(String identifier, String password) throws WSSecurityException {
        this.assertDefaultCryptoProvider();
        return this.fallbackCrypto.getPrivateKey(identifier, password);
    }

    public boolean verifyTrust(X509Certificate[] certs) throws WSSecurityException {
        return this.verifyTrust(certs, false);
    }

    public boolean verifyTrust(X509Certificate[] certs, boolean enableRevocation) throws WSSecurityException {
        if (certs != null) {
            LOG.fine(String.format("Verifying certificate id: %s", certs[0].getSubjectDN()));
        }
        XKMSCacheToken cachedToken = null;
        if (certs != null && certs.length > 0 && this.xkmsClientCache != null) {
            String key = certs[0].getSubjectX500Principal().getName();
            cachedToken = this.xkmsClientCache.get(key);
            if (cachedToken == null) {
                key = this.getKeyForIssuerSerial(certs[0].getIssuerX500Principal().getName(), certs[0].getSerialNumber());
                cachedToken = this.xkmsClientCache.get(key);
            }
            if (cachedToken != null && cachedToken.isXkmsValidated()) {
                LOG.fine("Certificate has already been validated by the XKMS service");
                return true;
            }
        }
        if (certs == null || certs[0] == null || !this.xkmsInvoker.validateCertificate(certs[0])) {
            throw new CryptoProviderException("The given certificate is not valid");
        }
        if (cachedToken != null) {
            cachedToken.setXkmsValidated(true);
        }
        this.storeCertificateInCache(certs[0], null, true);
        return true;
    }

    public boolean verifyTrust(PublicKey publicKey) throws WSSecurityException {
        throw new CryptoProviderException("PublicKeys cannot be verified");
    }

    private void assertDefaultCryptoProvider() {
        if (this.fallbackCrypto == null) {
            throw new UnsupportedOperationException("Not supported by this crypto provider");
        }
    }

    private X509Certificate[] getX509(CryptoType cryptoType) {
        X509Certificate[] localCerts;
        if (this.allowX509FromJKS && this.fallbackCrypto != null && (localCerts = this.getCertificateLocally(cryptoType)) != null && localCerts.length > 0) {
            return localCerts;
        }
        CryptoType.TYPE type = cryptoType.getType();
        if (type == CryptoType.TYPE.SUBJECT_DN) {
            return this.getX509FromXKMSByID(Applications.PKIX, cryptoType.getSubjectDN());
        }
        if (type == CryptoType.TYPE.ALIAS) {
            Applications appId = null;
            boolean isServiceName = this.isServiceName(cryptoType);
            appId = !isServiceName ? Applications.PKIX : Applications.SERVICE_SOAP;
            return this.getX509FromXKMSByID(appId, cryptoType.getAlias());
        }
        if (type == CryptoType.TYPE.ISSUER_SERIAL) {
            return this.getX509FromXKMSByIssuerSerial(cryptoType.getIssuer(), cryptoType.getSerial());
        }
        throw new IllegalArgumentException("Unsupported type " + type);
    }

    private X509Certificate[] getX509FromXKMSByID(Applications application, String id) {
        XKMSCacheToken cachedToken;
        LOG.fine(String.format("Getting public certificate from XKMS for application:%s; id: %s", application, id));
        if (id == null) {
            throw new IllegalArgumentException("Id is not specified for certificate request");
        }
        if (this.xkmsClientCache != null && (cachedToken = this.xkmsClientCache.get(id.toLowerCase())) != null && cachedToken.getX509Certificate() != null) {
            return new X509Certificate[]{cachedToken.getX509Certificate()};
        }
        X509Certificate cert = this.xkmsInvoker.getCertificateForId(application, id);
        this.storeCertificateInCache(cert, id.toLowerCase(), false);
        return new X509Certificate[]{cert};
    }

    private X509Certificate[] getX509FromXKMSByIssuerSerial(String issuer, BigInteger serial) {
        XKMSCacheToken cachedToken;
        LOG.fine(String.format("Getting public certificate from XKMS for issuer:%s; serial: %x", issuer, serial));
        String key = this.getKeyForIssuerSerial(issuer, serial);
        if (this.xkmsClientCache != null && (cachedToken = this.xkmsClientCache.get(key)) != null && cachedToken.getX509Certificate() != null) {
            return new X509Certificate[]{cachedToken.getX509Certificate()};
        }
        X509Certificate certificate = this.xkmsInvoker.getCertificateForIssuerSerial(issuer, serial);
        this.storeCertificateInCache(certificate, key, false);
        return new X509Certificate[]{certificate};
    }

    private X509Certificate[] getCertificateLocally(CryptoType cryptoType) {
        if (this.fallbackCrypto == null) {
            return null;
        }
        X509Certificate[] localCerts = null;
        try {
            localCerts = this.fallbackCrypto.getX509Certificates(cryptoType);
        }
        catch (Exception e) {
            LOG.info("Certificate is not found in local keystore using desired CryptoType: " + cryptoType.getType().name());
        }
        if (localCerts == null && cryptoType.getType() == CryptoType.TYPE.ALIAS) {
            CryptoType newCryptoType = new CryptoType(CryptoType.TYPE.SUBJECT_DN);
            newCryptoType.setSubjectDN(cryptoType.getAlias());
            try {
                localCerts = this.fallbackCrypto.getX509Certificates(newCryptoType);
            }
            catch (Exception e) {
                LOG.info("Certificate is not found in local keystore and will be requested from XKMS (first trying the cache): " + cryptoType.getAlias());
            }
        }
        return localCerts;
    }

    private boolean isServiceName(CryptoType cryptoType) {
        return cryptoType.getAlias().contains("{");
    }

    private String getKeyForIssuerSerial(String issuer, BigInteger serial) {
        return issuer + "-" + serial.toString(16);
    }

    private void storeCertificateInCache(X509Certificate certificate, String key, boolean validated) {
        if (certificate != null && this.xkmsClientCache != null) {
            String subjectDNKey;
            String issuerSerialKey;
            XKMSCacheToken cacheToken = new XKMSCacheToken(certificate);
            cacheToken.setXkmsValidated(validated);
            if (key != null) {
                this.xkmsClientCache.put(key, cacheToken);
            }
            if (!(issuerSerialKey = this.getKeyForIssuerSerial(certificate.getIssuerX500Principal().getName(), certificate.getSerialNumber())).equals(key)) {
                this.xkmsClientCache.put(issuerSerialKey, cacheToken);
            }
            if (!(subjectDNKey = certificate.getSubjectX500Principal().getName()).equals(key)) {
                this.xkmsClientCache.put(subjectDNKey, cacheToken);
            }
        }
    }
}

