/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.karaf.commands;

import java.util.Collections;
import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.karaf.commands.CXFController;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(scope="cxf", name="list-endpoints", description="Lists all CXF Endpoints on a Bus.")
public class ListEndpointsCommand
extends OsgiCommandSupport {
    protected static final String HEADER_FORMAT = "%-25s %-10s %-60s %-40s";
    protected static final String OUTPUT_FORMAT = "[%-23s] [%-8s] [%-58s] [%-38s]";
    @Argument(index=0, name="bus", description="The CXF bus name where to look for the Endpoints", required=false, multiValued=false)
    String name;
    private CXFController cxfController;

    public void setController(CXFController controller) {
        this.cxfController = controller;
    }

    protected Object doExecute() throws Exception {
        Bus b;
        List<Object> busses = this.name == null ? this.cxfController.getBusses() : ((b = this.cxfController.getBus(this.name)) != null ? Collections.singletonList(this.cxfController.getBus(this.name)) : Collections.emptyList());
        for (Bus b2 : busses) {
            ServerRegistry reg = (ServerRegistry)b2.getExtension(ServerRegistry.class);
            List servers = reg.getServers();
            System.out.println(String.format(HEADER_FORMAT, "Name", "State", "Address", "BusID"));
            for (Server serv : servers) {
                String qname = serv.getEndpoint().getEndpointInfo().getName().getLocalPart();
                String started = serv.isStarted() ? "Started" : "Stopped";
                String address = serv.getEndpoint().getEndpointInfo().getAddress();
                String busId = b2.getId();
                System.out.println(String.format(OUTPUT_FORMAT, qname, started, address, busId));
            }
        }
        return null;
    }
}

