/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.oidc.logout;

import java.util.List;
import org.apache.cxf.fediz.service.oidc.logout.LogoutHandler;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;

public class TokenCleanupHandler
implements LogoutHandler {
    private OAuthDataProvider dataProvider;
    private boolean removeTokensForAllClients;

    @Override
    public void handleLogout(Client client, UserSubject subject) {
        if (this.removeTokensForAllClients) {
            client = null;
        }
        List accessTokens = this.dataProvider.getAccessTokens(client, subject);
        for (ServerAccessToken at : accessTokens) {
            this.dataProvider.revokeToken(client, at.getTokenKey(), "access_token");
        }
    }

    public void setDataProvider(OAuthDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public void setRemoveTokensForAllClients(boolean removeTokensForAllClients) {
        this.removeTokensForAllClients = removeTokensForAllClients;
    }
}

