/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.oidc.logout;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.fediz.core.spi.ReplyConstraintCallback;
import org.apache.cxf.fediz.service.oidc.handler.hrd.ApplicationContextProvider;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.springframework.context.ApplicationContext;

public class LogoutRedirectConstraintHandler
implements CallbackHandler {
    private static final String POST_LOGOUT_REDIRECT_URIS = "post_logout_redirect_uris";

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks != null) {
            for (Callback callback : callbacks) {
                ReplyConstraintCallback replyConstraintCallback;
                HttpServletRequest request;
                if (!(callback instanceof ReplyConstraintCallback) || (request = (replyConstraintCallback = (ReplyConstraintCallback)callback).getRequest()) == null) continue;
                String clientId = request.getParameter("client_id");
                if (clientId == null) {
                    clientId = (String)request.getAttribute("client_id");
                }
                replyConstraintCallback.setReplyConstraint(this.getLogoutRedirectConstraint(clientId));
            }
        }
    }

    private Pattern getLogoutRedirectConstraint(String clientId) {
        String logoutUri;
        ApplicationContext ctx = ApplicationContextProvider.getApplicationContext();
        OAuthDataProvider dataManager = (OAuthDataProvider)ctx.getBean("oauthProvider");
        Client client = dataManager.getClient(clientId);
        if (client != null && (logoutUri = (String)client.getProperties().get(POST_LOGOUT_REDIRECT_URIS)) != null) {
            List<String> uris = Arrays.asList(logoutUri.split(" "));
            for (int i = 0; i < uris.size(); ++i) {
                uris.set(i, Pattern.quote(uris.get(i)));
            }
            return Pattern.compile("(" + String.join((CharSequence)"|", uris) + ")");
        }
        return null;
    }
}

