/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.oidc.handler.hrd;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.fediz.core.spi.HomeRealmCallback;
import org.apache.cxf.fediz.service.oidc.handler.hrd.ApplicationContextProvider;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ClientIdHomeRealmDiscovery
implements CallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ClientIdHomeRealmDiscovery.class);

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof HomeRealmCallback) {
                ApplicationContext ctx;
                OAuthDataProvider dataManager;
                Client client;
                HomeRealmCallback callback = (HomeRealmCallback)callbacks[i];
                HttpServletRequest request = callback.getRequest();
                String clientId = request.getParameter("client_id");
                if (clientId == null || (client = (dataManager = (OAuthDataProvider)(ctx = ApplicationContextProvider.getApplicationContext()).getBean("oauthProvider")).getClient(clientId)) == null) continue;
                callback.setHomeRealm(client.getHomeRealm());
                LOG.debug("Retrieved home realm {}", (Object)callback.getHomeRealm());
                continue;
            }
            LOG.warn("Callback is not an instance of HomeRealmCallback: {}", (Object)callbacks[i]);
        }
    }
}

