/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.oidc.clients;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.validator.routines.DomainValidator;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.fediz.service.oidc.CSRFUtils;
import org.apache.cxf.fediz.service.oidc.clients.ClientCodeGrants;
import org.apache.cxf.fediz.service.oidc.clients.ClientTokens;
import org.apache.cxf.fediz.service.oidc.clients.EditClient;
import org.apache.cxf.fediz.service.oidc.clients.InvalidRegistration;
import org.apache.cxf.fediz.service.oidc.clients.InvalidRegistrationException;
import org.apache.cxf.fediz.service.oidc.clients.RegisterClient;
import org.apache.cxf.fediz.service.oidc.clients.RegisteredClients;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.rs.security.oauth2.common.AccessToken;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.ClientRegistrationProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oidc.idp.OidcUserSubject;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

@Path(value="/")
public class ClientRegistrationService {
    private static final Logger LOG = LogUtils.getL7dLogger(ClientRegistrationService.class);
    private final Map<String, Collection<Client>> registrations = new HashMap<String, Collection<Client>>();
    private OAuthDataProvider dataProvider;
    private ClientRegistrationProvider clientProvider;
    private Map<String, String> homeRealms = Collections.emptyMap();
    private boolean protectIdTokenWithClientSecret;
    private Map<String, String> clientScopes;
    private MessageContext mc;
    private String userRole;

    @Context
    public void setMessageContext(MessageContext messageContext) {
        this.mc = messageContext;
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/register")
    public RegisterClient registerStart() {
        this.checkSecurityContext();
        return new RegisterClient(this.homeRealms);
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/")
    public RegisteredClients getClients() {
        this.checkSecurityContext();
        return new RegisteredClients(this.getClientRegistrations());
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/{id}")
    public Client getRegisteredClient(@PathParam(value="id") String id) {
        this.checkSecurityContext();
        for (Client c : this.getClientRegistrations()) {
            if (!c.getClientId().equals(id)) continue;
            return c;
        }
        return null;
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/{id}/edit")
    public EditClient editClient(@PathParam(value="id") String id) {
        this.checkSecurityContext();
        for (Client c : this.getClientRegistrations()) {
            if (!c.getClientId().equals(id)) continue;
            return new EditClient(c, this.homeRealms);
        }
        return null;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    @Path(value="/{id}/remove")
    public RegisteredClients removeClient(@PathParam(value="id") String id, @FormParam(value="client_csrfToken") String csrfToken) {
        this.checkCSRFToken(csrfToken);
        this.checkSecurityContext();
        Collection<Client> clients = this.getClientRegistrations();
        Iterator<Client> it = clients.iterator();
        while (it.hasNext()) {
            Client c = it.next();
            if (!c.getClientId().equals(id)) continue;
            this.clientProvider.removeClient(id);
            it.remove();
            break;
        }
        return new RegisteredClients(clients);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    @Path(value="/{id}/reset")
    public Client resetClient(@PathParam(value="id") String id, @FormParam(value="client_csrfToken") String csrfToken) {
        this.checkCSRFToken(csrfToken);
        this.checkSecurityContext();
        Client c = this.getRegisteredClient(id);
        if (c == null) {
            throw new InvalidRegistrationException("The client id is invalid");
        }
        if (c.isConfidential()) {
            c.setClientSecret(this.generateClientSecret());
        }
        this.clientProvider.setClient(c);
        return c;
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/{id}/tokens")
    public ClientTokens getClientIssuedTokens(@PathParam(value="id") String id) {
        this.checkSecurityContext();
        Client c = this.getRegisteredClient(id);
        if (c == null) {
            throw new InvalidRegistrationException("The client id is invalid");
        }
        return this.doGetClientIssuedTokens(c);
    }

    protected ClientTokens doGetClientIssuedTokens(Client c) {
        Comparator<AccessToken> tokenComp = Comparator.comparingLong(AccessToken::getIssuedAt);
        OidcUserSubject subject = new OidcUserSubject(this.getUserName());
        TreeSet<AccessToken> accessTokens = new TreeSet<AccessToken>(tokenComp);
        accessTokens.addAll(this.dataProvider.getAccessTokens(c, (UserSubject)subject));
        TreeSet<AccessToken> refreshTokens = new TreeSet<AccessToken>(tokenComp);
        refreshTokens.addAll(this.dataProvider.getRefreshTokens(c, (UserSubject)subject));
        return new ClientTokens(c, accessTokens, refreshTokens);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    @Path(value="/{id}/at/{tokenId}/revoke")
    public ClientTokens revokeClientAccessToken(@PathParam(value="id") String clientId, @PathParam(value="tokenId") String tokenId, @FormParam(value="client_csrfToken") String csrfToken) {
        return this.doRevokeClientToken(clientId, csrfToken, tokenId, "access_token");
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    @Path(value="/{id}/rt/{tokenId}/revoke")
    public ClientTokens revokeClientRefreshToken(@PathParam(value="id") String clientId, @PathParam(value="tokenId") String tokenId, @FormParam(value="client_csrfToken") String csrfToken) {
        return this.doRevokeClientToken(clientId, csrfToken, tokenId, "refresh_token");
    }

    protected ClientTokens doRevokeClientToken(String clientId, String csrfToken, String tokenId, String tokenType) {
        this.checkCSRFToken(csrfToken);
        this.checkSecurityContext();
        Client c = this.getRegisteredClient(clientId);
        if (c == null) {
            throw new InvalidRegistrationException("The client id is invalid");
        }
        this.dataProvider.revokeToken(c, tokenId, tokenType);
        return this.doGetClientIssuedTokens(c);
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/{id}/codes")
    public ClientCodeGrants getClientCodeGrants(@PathParam(value="id") String id) {
        this.checkSecurityContext();
        if (this.dataProvider instanceof AuthorizationCodeDataProvider) {
            Client c = this.getRegisteredClient(id);
            if (c == null) {
                throw new InvalidRegistrationException("The client id is invalid");
            }
            OidcUserSubject subject = new OidcUserSubject(this.getUserName());
            TreeSet<ServerAuthorizationCodeGrant> codeGrants = new TreeSet<ServerAuthorizationCodeGrant>(Comparator.comparingLong(ServerAuthorizationCodeGrant::getIssuedAt));
            codeGrants.addAll(((AuthorizationCodeDataProvider)this.dataProvider).getCodeGrants(c, (UserSubject)subject));
            return new ClientCodeGrants(c, codeGrants);
        }
        return null;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    @Path(value="/{id}/codes/{code}/revoke")
    public ClientCodeGrants revokeClientCodeGrant(@PathParam(value="id") String id, @PathParam(value="code") String code, @FormParam(value="client_csrfToken") String csrfToken) {
        this.checkCSRFToken(csrfToken);
        this.checkSecurityContext();
        if (this.dataProvider instanceof AuthorizationCodeDataProvider) {
            ((AuthorizationCodeDataProvider)this.dataProvider).removeCodeGrant(code);
            return this.getClientCodeGrants(id);
        }
        return null;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    @Path(value="/")
    public Response registerForm(@FormParam(value="client_name") String appName, @FormParam(value="client_type") String appType, @FormParam(value="client_audience") String audience, @FormParam(value="client_redirectURI") String redirectURI, @FormParam(value="client_logoutURI") String logoutURI, @FormParam(value="client_homeRealm") String homeRealm, @FormParam(value="client_csrfToken") String csrfToken) {
        try {
            this.checkCSRFToken(csrfToken);
            this.checkSecurityContext();
            if (StringUtils.isEmpty((String)appName)) {
                throw new InvalidRegistrationException("The client name must not be empty");
            }
            if (StringUtils.isEmpty((String)appType)) {
                throw new InvalidRegistrationException("The client type must not be empty");
            }
            if (!"confidential".equals(appType) && !"public".equals(appType)) {
                throw new InvalidRegistrationException("An invalid client type was specified: " + StringEscapeUtils.escapeHtml4((String)appType));
            }
            String clientId = this.generateClientId();
            boolean isConfidential = "confidential".equals(appType);
            String clientSecret = isConfidential ? this.generateClientSecret() : null;
            Client newClient = new Client(clientId, clientSecret, isConfidential, appName);
            String userName = this.getUserName();
            OidcUserSubject userSubject = new OidcUserSubject(userName);
            newClient.setResourceOwnerSubject((UserSubject)userSubject);
            newClient.setRegisteredAt(System.currentTimeMillis() / 1000L);
            this.updateClientDetails(newClient, audience, redirectURI, logoutURI, homeRealm);
            if (this.clientScopes != null && !this.clientScopes.isEmpty()) {
                newClient.setRegisteredScopes(new ArrayList<String>(this.clientScopes.keySet()));
            }
            return Response.ok((Object)this.registerNewClient(newClient)).build();
        }
        catch (InvalidRegistrationException ex) {
            return Response.ok((Object)new InvalidRegistration(ex.getMessage())).build();
        }
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    @Path(value="/{id}")
    public Response editForm(@PathParam(value="id") String clientId, @FormParam(value="client_name") String appName, @FormParam(value="client_audience") String audience, @FormParam(value="client_redirectURI") String redirectURI, @FormParam(value="client_logoutURI") String logoutURI, @FormParam(value="client_homeRealm") String homeRealm, @FormParam(value="client_csrfToken") String csrfToken) {
        try {
            this.checkCSRFToken(csrfToken);
            Client client = this.getRegisteredClient(clientId);
            if (StringUtils.isEmpty((String)appName)) {
                throw new InvalidRegistrationException("The client name must not be empty");
            }
            this.updateClientDetails(client, audience, redirectURI, logoutURI, homeRealm);
            if (!client.getApplicationName().equals(appName)) {
                Collection<Client> clientRegistrations = this.getClientRegistrations(client.getResourceOwnerSubject().getLogin());
                Iterator<Client> it = clientRegistrations.iterator();
                while (it.hasNext()) {
                    Client c = it.next();
                    if (!c.getClientId().equals(clientId)) continue;
                    it.remove();
                    break;
                }
                client.setApplicationName(appName);
                ClientRegistrationService.updateClientApplicationName(client, clientRegistrations);
                clientRegistrations.add(client);
            }
            this.clientProvider.setClient(client);
            return Response.ok((Object)client).build();
        }
        catch (InvalidRegistrationException ex) {
            return Response.ok((Object)new InvalidRegistration(ex.getMessage())).build();
        }
    }

    private void updateClientDetails(Client client, String audience, String redirectURI, String logoutURI, String homeRealm) {
        if (!StringUtils.isEmpty((String)redirectURI)) {
            String[] allUris = redirectURI.trim().split(" ");
            String[] redirectUris = new ArrayList(allUris.length);
            String[] stringArray = allUris;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String uri = stringArray[i];
                if (StringUtils.isEmpty((String)uri)) continue;
                if (!ClientRegistrationService.isValidURI(uri, false)) {
                    throw new InvalidRegistrationException("An invalid redirect URI was specified: " + StringEscapeUtils.escapeHtml4((String)uri));
                }
                redirectUris.add(uri);
            }
            client.setRedirectUris((List)redirectUris);
        } else {
            client.setRedirectUris(Collections.emptyList());
        }
        if (!StringUtils.isEmpty((String)logoutURI)) {
            String[] logoutUris;
            for (String uri : logoutUris = logoutURI.split(" ")) {
                if (ClientRegistrationService.isValidURI(uri, false)) continue;
                throw new InvalidRegistrationException("An invalid logout URI was specified: " + StringEscapeUtils.escapeHtml4((String)uri));
            }
            client.getProperties().put("post_logout_redirect_uris", logoutURI);
        } else {
            client.getProperties().remove("post_logout_redirect_uris");
        }
        if (!StringUtils.isEmpty((String)audience)) {
            String[] auds = audience.trim().split(" ");
            ArrayList<String> registeredAuds = new ArrayList<String>(auds.length);
            for (String aud : auds) {
                if (StringUtils.isEmpty((String)aud)) continue;
                if (!ClientRegistrationService.isValidURI(aud, true)) {
                    throw new InvalidRegistrationException("An invalid audience URI was specified: " + StringEscapeUtils.escapeHtml4((String)aud));
                }
                registeredAuds.add(aud);
            }
            client.setRegisteredAudiences(registeredAuds);
        } else {
            client.setRegisteredAudiences(Collections.emptyList());
        }
        if (homeRealm != null) {
            client.setHomeRealm(homeRealm);
            if (this.homeRealms.containsKey(homeRealm)) {
                client.getProperties().put("homeRealmAlias", this.homeRealms.get(homeRealm));
            } else {
                client.getProperties().remove("homeRealmAlias");
            }
        }
    }

    private void checkSecurityContext() {
        SecurityContext sc = this.mc.getSecurityContext();
        if (sc == null || sc.getUserPrincipal() == null) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
        if (this.userRole != null && !sc.isUserInRole(this.userRole)) {
            throw ExceptionUtils.toForbiddenException(null, null);
        }
    }

    private void checkCSRFToken(String csrfToken) {
        HttpServletRequest httpRequest = this.mc.getHttpServletRequest();
        String savedToken = CSRFUtils.getCSRFToken(httpRequest, false);
        if (StringUtils.isEmpty((String)csrfToken) || StringUtils.isEmpty((String)savedToken) || !savedToken.equals(csrfToken)) {
            throw new InvalidRegistrationException("Invalid CSRF Token");
        }
    }

    private static boolean isValidURI(String uri, boolean requireHttps) {
        String[] schemes = requireHttps ? new String[]{"https"} : new String[]{"https", "http"};
        UrlValidator urlValidator = new UrlValidator(schemes, 8L);
        if (!urlValidator.isValid(uri)) {
            return false;
        }
        try {
            URI parsedURI = new URI(uri);
            if (parsedURI.getFragment() != null) {
                return false;
            }
        }
        catch (URISyntaxException ex) {
            return false;
        }
        return true;
    }

    protected String generateClientId() {
        return Base64UrlUtility.encode((byte[])CryptoUtils.generateSecureRandomBytes((int)10));
    }

    protected String generateClientSecret() {
        int keySizeOctets = this.protectIdTokenWithClientSecret ? 32 : 16;
        return Base64UrlUtility.encode((byte[])CryptoUtils.generateSecureRandomBytes((int)keySizeOctets));
    }

    protected RegisteredClients registerNewClient(Client newClient) {
        Collection<Client> clientRegistrations = this.getClientRegistrations(newClient.getResourceOwnerSubject().getLogin());
        ClientRegistrationService.updateClientApplicationName(newClient, clientRegistrations);
        this.clientProvider.setClient(newClient);
        clientRegistrations.add(newClient);
        return new RegisteredClients(clientRegistrations);
    }

    private static void updateClientApplicationName(Client client, Collection<Client> clientRegistrations) {
        HashSet<String> names = new HashSet<String>();
        for (Client c : clientRegistrations) {
            names.add(c.getApplicationName());
        }
        if (names.contains(client.getApplicationName())) {
            String newName = client.getApplicationName();
            TreeSet<Integer> numbers = new TreeSet<Integer>();
            for (String name : names) {
                if (!name.startsWith(newName) || name.equals(newName)) continue;
                try {
                    numbers.add(Integer.valueOf(name.substring(newName.length())));
                }
                catch (Exception exception) {}
            }
            int nextNumber = numbers.isEmpty() ? 2 : (Integer)numbers.last() + 1;
            client.setApplicationName(newName + nextNumber);
        }
    }

    protected Collection<Client> getClientRegistrations() {
        return this.getClientRegistrations(this.getUserName());
    }

    protected Collection<Client> getClientRegistrations(String userName) {
        Collection<Client> userClientRegs = this.registrations.get(userName);
        if (userClientRegs == null) {
            userClientRegs = new TreeSet<Client>(Comparator.comparing(Client::getApplicationName));
            this.registrations.put(userName, userClientRegs);
        }
        return userClientRegs;
    }

    private String getUserName() {
        SecurityContext sc = this.mc.getSecurityContext();
        if (sc == null || sc.getUserPrincipal() == null) {
            return null;
        }
        return sc.getUserPrincipal().getName();
    }

    public void setHomeRealms(Map<String, String> homeRealms) {
        this.homeRealms = homeRealms;
    }

    public void init() {
        for (Client c : this.clientProvider.getClients(null)) {
            if (c.getResourceOwnerSubject() == null) continue;
            String userName = c.getResourceOwnerSubject().getLogin();
            this.getClientRegistrations(userName).add(c);
        }
    }

    public void setProtectIdTokenWithClientSecret(boolean protectIdTokenWithClientSecret) {
        this.protectIdTokenWithClientSecret = protectIdTokenWithClientSecret;
    }

    public void setClientScopes(Map<String, String> clientScopes) {
        this.clientScopes = clientScopes;
    }

    public OAuthDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(OAuthDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public void setClientProvider(ClientRegistrationProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    public void setAdditionalTLDs(List<String> additionalTLDs) {
        if (additionalTLDs != null && !additionalTLDs.isEmpty()) {
            try {
                LOG.info("Adding the following additional Top Level Domains: " + additionalTLDs);
                DomainValidator.updateTLDOverride((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_PLUS, (String[])additionalTLDs.toArray(new String[0]));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void setUserRole(String userRole) {
        this.userRole = userRole;
    }
}

