/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.oidc;

import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

public final class CSRFUtils {
    public static final String CSRF_TOKEN = "CSRF_TOKEN";

    private CSRFUtils() {
    }

    public static String getCSRFToken(HttpServletRequest request, boolean create) {
        if (request != null && request.getSession() != null) {
            String savedToken = (String)request.getSession().getAttribute(CSRF_TOKEN);
            if (savedToken != null) {
                return savedToken;
            }
            if (create) {
                String token = StringUtils.toHexString((byte[])CryptoUtils.generateSecureRandomBytes((int)32));
                request.getSession().setAttribute(CSRF_TOKEN, (Object)token);
                return token;
            }
        }
        return null;
    }
}

