/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.sts.realms;

import java.security.Principal;
import org.apache.cxf.sts.IdentityMapper;
import org.apache.wss4j.common.principal.CustomTokenPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealmExtensionIdentityMapper
implements IdentityMapper {
    public static final String DEFAULT_DELIMITER = "@";
    private static final Logger LOG = LoggerFactory.getLogger(RealmExtensionIdentityMapper.class);
    private String delimiter = "@";

    public Principal mapPrincipal(String sourceRealm, Principal sourcePrincipal, String targetRealm) {
        if (sourcePrincipal == null) {
            return null;
        }
        String name = sourcePrincipal.getName().toLowerCase();
        if (name.contains(this.delimiter)) {
            name = name.substring(0, name.indexOf(this.delimiter));
        }
        name = name + this.getDelimiter() + targetRealm;
        LOG.debug("Principal '{}' mapped to '{}'", (Object)sourcePrincipal.getName(), (Object)name);
        return new CustomTokenPrincipal(name);
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

