/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import org.apache.zookeeper.server.ServerStats;

public class QuorumStats
extends ServerStats {
    private Provider qprovider = null;

    public static QuorumStats getInstance() {
        ServerStats i = ServerStats.getInstance();
        assert (i == null || i instanceof QuorumStats);
        return (QuorumStats)i;
    }

    public static void registerAsConcrete() {
        assert (QuorumStats.getInstance() == null);
        QuorumStats.setInstance(new QuorumStats());
    }

    protected QuorumStats() {
    }

    public void setStatsProvider(Provider newProvider) {
        this.qprovider = newProvider;
    }

    public String getServerState() {
        return this.qprovider != null ? this.qprovider.getServerState() : "unknown";
    }

    public String[] getQuorumPeers() {
        return this.qprovider != null ? this.qprovider.getQuorumPeers() : new String[]{};
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        String state = this.getServerState();
        if (state.equals("leading")) {
            sb.append("Followers:");
            for (String f : this.getQuorumPeers()) {
                sb.append(" ").append(f);
            }
            sb.append("\n");
        } else if (state.equals("following")) {
            sb.append("Leader: ");
            String[] ldr = this.getQuorumPeers();
            if (ldr.length > 0) {
                sb.append(ldr[0]);
            } else {
                sb.append("not connected");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static interface Provider {
        public static final String UNKNOWN_STATE = "unknown";
        public static final String LOOKING_STATE = "leaderelection";
        public static final String LEADING_STATE = "leading";
        public static final String FOLLOWING_STATE = "following";

        public String[] getQuorumPeers();

        public String getServerState();
    }
}

