/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;
import org.apache.zookeeper.server.quorum.Election;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.Vote;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeaderElection
implements Election {
    private static final Logger LOG = Logger.getLogger(LeaderElection.class);
    QuorumPeer self;

    public LeaderElection(QuorumPeer self) {
        this.self = self;
    }

    private ElectionResult countVotes(HashMap<InetSocketAddress, Vote> votes, HashSet<Long> heardFrom) {
        ElectionResult result = new ElectionResult();
        result.vote = new Vote(Long.MIN_VALUE, Long.MIN_VALUE);
        result.winner = new Vote(Long.MIN_VALUE, Long.MIN_VALUE);
        Collection<Vote> votesCast = votes.values();
        Iterator<Vote> i = votesCast.iterator();
        while (i.hasNext()) {
            Vote v = i.next();
            if (!heardFrom.contains(v.id)) {
                i.remove();
                continue;
            }
            for (Vote w : votesCast) {
                if (v.id != w.id || v.zxid >= w.zxid) continue;
                v.zxid = w.zxid;
            }
        }
        HashMap<Vote, Integer> countTable = new HashMap<Vote, Integer>();
        for (Vote vote : votesCast) {
            Integer count = (Integer)countTable.get(vote);
            if (count == null) {
                count = 0;
            }
            countTable.put(vote, count + 1);
            if (vote.id == result.vote.id) {
                ++result.count;
                continue;
            }
            if (vote.zxid <= result.vote.zxid && (vote.zxid != result.vote.zxid || vote.id <= result.vote.id)) continue;
            result.vote = vote;
            result.count = 1;
        }
        result.winningCount = 0;
        LOG.warn((Object)"Election tally: ");
        for (Map.Entry entry : countTable.entrySet()) {
            if ((Integer)entry.getValue() > result.winningCount) {
                result.winningCount = (Integer)entry.getValue();
                result.winner = (Vote)entry.getKey();
            }
            LOG.warn((Object)(((Vote)entry.getKey()).id + "\t-> " + entry.getValue()));
        }
        return result;
    }

    @Override
    public Vote lookForLeader() throws InterruptedException {
        this.self.setCurrentVote(new Vote(this.self.getId(), this.self.getLastLoggedZxid()));
        byte[] requestBytes = new byte[4];
        ByteBuffer requestBuffer = ByteBuffer.wrap(requestBytes);
        byte[] responseBytes = new byte[28];
        ByteBuffer responseBuffer = ByteBuffer.wrap(responseBytes);
        DatagramSocket s = null;
        try {
            s = new DatagramSocket();
            s.setSoTimeout(200);
        }
        catch (SocketException e1) {
            e1.printStackTrace();
            System.exit(4);
        }
        DatagramPacket requestPacket = new DatagramPacket(requestBytes, requestBytes.length);
        DatagramPacket responsePacket = new DatagramPacket(responseBytes, responseBytes.length);
        HashMap<InetSocketAddress, Vote> votes = new HashMap<InetSocketAddress, Vote>(this.self.quorumPeers.size());
        int xid = new Random().nextInt();
        while (this.self.running) {
            votes.clear();
            requestBuffer.clear();
            requestBuffer.putInt(xid);
            requestPacket.setLength(4);
            HashSet<Long> heardFrom = new HashSet<Long>();
            for (QuorumPeer.QuorumServer server : this.self.quorumPeers.values()) {
                requestPacket.setSocketAddress(server.addr);
                LOG.warn((Object)("Server address: " + server.addr));
                try {
                    s.send(requestPacket);
                    responsePacket.setLength(responseBytes.length);
                    s.receive(responsePacket);
                    if (responsePacket.getLength() != responseBytes.length) {
                        LOG.error((Object)("Got a short response: " + responsePacket.getLength()));
                        continue;
                    }
                    responseBuffer.clear();
                    int recvedXid = responseBuffer.getInt();
                    if (recvedXid != xid) {
                        LOG.error((Object)("Got bad xid: expected " + xid + " got " + recvedXid));
                        continue;
                    }
                    long peerId = responseBuffer.getLong();
                    heardFrom.add(peerId);
                    Vote vote = new Vote(responseBuffer.getLong(), responseBuffer.getLong());
                    InetSocketAddress addr = (InetSocketAddress)responsePacket.getSocketAddress();
                    votes.put(addr, vote);
                }
                catch (IOException e) {
                    LOG.error((Object)"Error in looking for leader", (Throwable)e);
                }
            }
            ElectionResult result = this.countVotes(votes, heardFrom);
            if (result.winner.id >= 0L) {
                this.self.setCurrentVote(result.vote);
                if (result.winningCount > this.self.quorumPeers.size() / 2) {
                    this.self.setCurrentVote(result.winner);
                    s.close();
                    Vote current = this.self.getCurrentVote();
                    this.self.setPeerState(current.id == this.self.getId() ? QuorumPeer.ServerState.LEADING : QuorumPeer.ServerState.FOLLOWING);
                    if (this.self.getPeerState() == QuorumPeer.ServerState.FOLLOWING) {
                        Thread.sleep(100L);
                    }
                    return current;
                }
            }
            Thread.sleep(1000L);
        }
        return null;
    }

    public static class ElectionResult {
        public Vote vote;
        public int count;
        public Vote winner;
        public int winningCount;
    }
}

