/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.jute.Record;
import org.apache.log4j.Logger;
import org.apache.zookeeper.server.FinalRequestProcessor;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.CommitProcessor;
import org.apache.zookeeper.server.quorum.Follower;
import org.apache.zookeeper.server.quorum.FollowerRequestProcessor;
import org.apache.zookeeper.server.quorum.FollowerSessionTracker;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.SendAckRequestProcessor;
import org.apache.zookeeper.txn.TxnHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FollowerZooKeeperServer
extends ZooKeeperServer {
    private static final Logger LOG = Logger.getLogger(FollowerZooKeeperServer.class);
    private QuorumPeer self;
    CommitProcessor commitProcessor;
    SyncRequestProcessor syncProcessor;
    ConcurrentLinkedQueue<Request> pendingSyncs;
    LinkedBlockingQueue<Request> pendingTxns = new LinkedBlockingQueue();

    FollowerZooKeeperServer(FileTxnSnapLog logFactory, QuorumPeer self, ZooKeeperServer.DataTreeBuilder treeBuilder) throws IOException {
        super(logFactory, self.tickTime, treeBuilder);
        this.self = self;
        this.pendingSyncs = new ConcurrentLinkedQueue();
    }

    public Follower getFollower() {
        return this.self.follower;
    }

    @Override
    protected void createSessionTracker() {
        this.sessionTracker = new FollowerSessionTracker(this, this.sessionsWithTimeouts, this.self.getId());
    }

    @Override
    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        this.commitProcessor = new CommitProcessor(finalProcessor, Integer.toString(this.getClientPort()), true);
        this.firstProcessor = new FollowerRequestProcessor(this, this.commitProcessor);
        this.syncProcessor = new SyncRequestProcessor(this, new SendAckRequestProcessor(this.getFollower()));
    }

    @Override
    protected void revalidateSession(ServerCnxn cnxn, long sessionId, int sessionTimeout) throws IOException, InterruptedException {
        this.getFollower().validateSession(cnxn, sessionId, sessionTimeout);
    }

    public HashMap<Long, Integer> getTouchSnapshot() {
        if (this.sessionTracker != null) {
            return ((FollowerSessionTracker)this.sessionTracker).snapshot();
        }
        return new HashMap<Long, Integer>();
    }

    @Override
    public long getServerId() {
        return this.self.getId();
    }

    public void logRequest(TxnHeader hdr, Record txn) {
        Request request = new Request(null, hdr.getClientId(), hdr.getCxid(), hdr.getType(), null, null);
        request.hdr = hdr;
        request.txn = txn;
        request.zxid = hdr.getZxid();
        if ((request.zxid & 0xFFFFFFFFL) != 0L) {
            this.pendingTxns.add(request);
        }
        this.syncProcessor.processRequest(request);
    }

    public void commit(long zxid) {
        if (this.pendingTxns.size() == 0) {
            LOG.warn((Object)("Committing " + Long.toHexString(zxid) + " without seeing txn"));
            return;
        }
        long firstElementZxid = ((Request)this.pendingTxns.element()).zxid;
        if (firstElementZxid != zxid) {
            LOG.error((Object)("Committing zxid 0x" + Long.toHexString(zxid) + " but next pending txn 0x" + Long.toHexString(firstElementZxid)));
            System.exit(12);
        }
        Request request = (Request)this.pendingTxns.remove();
        this.commitProcessor.commit(request);
    }

    public synchronized void sync() {
        if (this.pendingSyncs.size() == 0) {
            LOG.warn((Object)"Not expecting a sync.");
            return;
        }
        Request r = (Request)this.pendingSyncs.remove();
        this.commitProcessor.commit(r);
    }

    @Override
    public int getGlobalOutstandingLimit() {
        return super.getGlobalOutstandingLimit() / (this.self.getQuorumSize() - 1);
    }

    @Override
    public void addCommittedProposal(Request r) {
    }

    @Override
    public void shutdown() {
        try {
            super.shutdown();
        }
        catch (Exception e) {
            LOG.error((Object)"FIXMSG", (Throwable)e);
        }
        try {
            if (this.syncProcessor != null) {
                this.syncProcessor.shutdown();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"FIXMSG", (Throwable)e);
        }
    }
}

