/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.zookeeper.server.quorum.Election;
import org.apache.zookeeper.server.quorum.QuorumCnxManager;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.Vote;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastLeaderElection
implements Election {
    private static final Logger LOG = Logger.getLogger(FastLeaderElection.class);
    static int sequencer = 0;
    static int finalizeWait = 200;
    static int challengeCounter = 0;
    QuorumCnxManager manager;
    LinkedBlockingQueue<ToSend> sendqueue;
    LinkedBlockingQueue<Notification> recvqueue;
    QuorumPeer self;
    int port;
    volatile long logicalclock;
    Messenger messenger;
    long proposedLeader;
    long proposedZxid;

    public long getLogicalClock() {
        return this.logicalclock;
    }

    public FastLeaderElection(QuorumPeer self, QuorumCnxManager manager) {
        this.manager = manager;
        this.starter(self, manager);
    }

    private void starter(QuorumPeer self, QuorumCnxManager manager) {
        this.self = self;
        this.proposedLeader = -1L;
        this.proposedZxid = -1L;
        this.sendqueue = new LinkedBlockingQueue();
        this.recvqueue = new LinkedBlockingQueue();
        this.messenger = new Messenger(manager);
    }

    private void leaveInstance() {
        this.recvqueue.clear();
    }

    public void shutdown() {
        this.manager.halt();
    }

    private void sendNotifications() {
        for (QuorumPeer.QuorumServer server : this.self.quorumPeers.values()) {
            long sid = server.id;
            ToSend notmsg = new ToSend(ToSend.mType.notification, this.proposedLeader, this.proposedZxid, this.logicalclock, QuorumPeer.ServerState.LOOKING, sid);
            this.sendqueue.offer(notmsg);
        }
    }

    private boolean totalOrderPredicate(long id, long zxid) {
        return zxid > this.proposedZxid || zxid == this.proposedZxid && id > this.proposedLeader;
    }

    private boolean termPredicate(HashMap<Long, Vote> votes, Vote vote) {
        Collection<Vote> votesCast = votes.values();
        int count = 0;
        for (Vote v : votesCast) {
            if (!v.equals(vote)) continue;
            ++count;
        }
        return count > this.self.quorumPeers.size() / 2;
    }

    private boolean checkLeader(HashMap<Long, Vote> votes, long leader, long epoch) {
        boolean predicate = true;
        if (votes.get(leader) == null) {
            predicate = false;
        } else if (votes.get((Object)Long.valueOf((long)leader)).state != QuorumPeer.ServerState.LEADING) {
            predicate = false;
        }
        return predicate;
    }

    synchronized void updateProposal(long leader, long zxid) {
        this.proposedLeader = leader;
        this.proposedZxid = zxid;
    }

    synchronized Vote getVote() {
        return new Vote(this.proposedLeader, this.proposedZxid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vote lookForLeader() throws InterruptedException {
        HashMap<Long, Vote> recvset = new HashMap<Long, Vote>();
        HashMap<Long, Vote> outofelection = new HashMap<Long, Vote>();
        FastLeaderElection fastLeaderElection = this;
        synchronized (fastLeaderElection) {
            ++this.logicalclock;
            this.updateProposal(this.self.getId(), this.self.getLastLoggedZxid());
        }
        LOG.warn((Object)("New election: " + this.proposedZxid));
        this.sendNotifications();
        while (this.self.getPeerState() == QuorumPeer.ServerState.LOOKING) {
            Notification n = this.recvqueue.poll(2 * finalizeWait, TimeUnit.MILLISECONDS);
            if (n == null) {
                if (!this.manager.haveDelivered()) continue;
                this.sendNotifications();
                continue;
            }
            switch (n.state) {
                case LOOKING: {
                    LOG.info((Object)("Notification: " + n.leader + ", " + n.zxid + ", " + n.epoch + ", " + this.self.getId() + ", " + (Object)((Object)this.self.getPeerState()) + ", " + (Object)((Object)n.state) + ", " + n.sid));
                    if (n.epoch > this.logicalclock) {
                        this.logicalclock = n.epoch;
                        recvset.clear();
                        this.updateProposal(this.self.getId(), this.self.getLastLoggedZxid());
                        this.sendNotifications();
                    } else {
                        if (n.epoch < this.logicalclock) break;
                        if (this.totalOrderPredicate(n.leader, n.zxid)) {
                            this.updateProposal(n.leader, n.zxid);
                            this.sendNotifications();
                        }
                    }
                    recvset.put(n.sid, new Vote(n.leader, n.zxid, n.epoch));
                    if (this.self.quorumPeers.size() == recvset.size()) {
                        this.self.setPeerState(this.proposedLeader == this.self.getId() ? QuorumPeer.ServerState.LEADING : QuorumPeer.ServerState.FOLLOWING);
                        this.leaveInstance();
                        return new Vote(this.proposedLeader, this.proposedZxid);
                    }
                    if (!this.termPredicate(recvset, new Vote(this.proposedLeader, this.proposedZxid, this.logicalclock))) break;
                    LOG.debug((Object)"Passed predicate");
                    while ((n = this.recvqueue.poll(finalizeWait, TimeUnit.MILLISECONDS)) != null) {
                        if (!this.totalOrderPredicate(n.leader, n.zxid)) continue;
                        this.recvqueue.put(n);
                        break;
                    }
                    if (n != null) break;
                    this.self.setPeerState(this.proposedLeader == this.self.getId() ? QuorumPeer.ServerState.LEADING : QuorumPeer.ServerState.FOLLOWING);
                    LOG.info((Object)("About to leave instance:" + this.proposedLeader + ", " + this.proposedZxid + ", " + this.self.getId() + ", " + (Object)((Object)this.self.getPeerState())));
                    this.leaveInstance();
                    return new Vote(this.proposedLeader, this.proposedZxid);
                }
                case LEADING: {
                    if (n.epoch == this.logicalclock) {
                        this.self.setPeerState(n.leader == this.self.getId() ? QuorumPeer.ServerState.LEADING : QuorumPeer.ServerState.FOLLOWING);
                        this.leaveInstance();
                        return new Vote(n.leader, n.zxid);
                    }
                }
                case FOLLOWING: {
                    LOG.info((Object)("Notification: " + n.leader + ", " + n.zxid + ", " + n.epoch + ", " + this.self.getId() + ", " + (Object)((Object)this.self.getPeerState()) + ", " + (Object)((Object)n.state) + ", " + n.sid));
                    outofelection.put(n.sid, new Vote(n.leader, n.zxid, n.epoch, n.state));
                    if (!this.termPredicate(outofelection, new Vote(n.leader, n.zxid, n.epoch, n.state)) || !this.checkLeader(outofelection, n.leader, n.epoch)) break;
                    FastLeaderElection fastLeaderElection2 = this;
                    synchronized (fastLeaderElection2) {
                        this.logicalclock = n.epoch;
                        this.self.setPeerState(n.leader == this.self.getId() ? QuorumPeer.ServerState.LEADING : QuorumPeer.ServerState.FOLLOWING);
                    }
                    this.leaveInstance();
                    return new Vote(n.leader, n.zxid);
                }
            }
        }
        return null;
    }

    private class Messenger {
        public boolean queueEmpty() {
            return FastLeaderElection.this.sendqueue.isEmpty() || FastLeaderElection.this.recvqueue.isEmpty();
        }

        Messenger(QuorumCnxManager manager) {
            Thread t = new Thread((Runnable)new WorkerSender(manager), "WorkerSender Thread");
            t.setDaemon(true);
            t.start();
            t = new Thread((Runnable)new WorkerReceiver(manager), "WorkerReceiver Thread");
            t.setDaemon(true);
            t.start();
        }

        class WorkerSender
        implements Runnable {
            QuorumCnxManager manager;

            WorkerSender(QuorumCnxManager manager) {
                this.manager = manager;
            }

            public void run() {
                try {
                    while (true) {
                        ToSend m = FastLeaderElection.this.sendqueue.take();
                        this.process(m);
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }

            private void process(ToSend m) {
                byte[] requestBytes = new byte[28];
                ByteBuffer requestBuffer = ByteBuffer.wrap(requestBytes);
                requestBuffer.clear();
                requestBuffer.putInt(m.state.ordinal());
                requestBuffer.putLong(m.leader);
                requestBuffer.putLong(m.zxid);
                requestBuffer.putLong(m.epoch);
                this.manager.toSend(m.sid, requestBuffer);
            }
        }

        class WorkerReceiver
        implements Runnable {
            QuorumCnxManager manager;

            WorkerReceiver(QuorumCnxManager manager) {
                this.manager = manager;
            }

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            ToSend notmsg;
                            QuorumCnxManager.Message response = this.manager.recvQueue.take();
                            if (response.buffer.capacity() < 28) {
                                LOG.error((Object)("Got a short response: " + response.buffer.capacity()));
                                continue;
                            }
                            response.buffer.clear();
                            QuorumPeer.ServerState ackstate = QuorumPeer.ServerState.LOOKING;
                            switch (response.buffer.getInt()) {
                                case 0: {
                                    ackstate = QuorumPeer.ServerState.LOOKING;
                                    break;
                                }
                                case 1: {
                                    ackstate = QuorumPeer.ServerState.FOLLOWING;
                                    break;
                                }
                                case 2: {
                                    ackstate = QuorumPeer.ServerState.LEADING;
                                }
                            }
                            Notification n = new Notification();
                            n.leader = response.buffer.getLong();
                            n.zxid = response.buffer.getLong();
                            n.epoch = response.buffer.getLong();
                            n.state = ackstate;
                            n.sid = response.sid;
                            if (FastLeaderElection.this.self.getPeerState() == QuorumPeer.ServerState.LOOKING) {
                                FastLeaderElection.this.recvqueue.offer(n);
                                if (FastLeaderElection.this.recvqueue.size() == 0) {
                                    LOG.debug((Object)("Message: " + n.sid));
                                }
                                if (ackstate != QuorumPeer.ServerState.LOOKING || n.epoch >= FastLeaderElection.this.logicalclock) continue;
                                Vote v = FastLeaderElection.this.getVote();
                                notmsg = new ToSend(ToSend.mType.notification, v.id, v.zxid, FastLeaderElection.this.logicalclock, FastLeaderElection.this.self.getPeerState(), response.sid);
                                FastLeaderElection.this.sendqueue.offer(notmsg);
                                continue;
                            }
                            Vote current = FastLeaderElection.this.self.getCurrentVote();
                            if (ackstate != QuorumPeer.ServerState.LOOKING) continue;
                            notmsg = new ToSend(ToSend.mType.notification, current.id, current.zxid, FastLeaderElection.this.logicalclock, FastLeaderElection.this.self.getPeerState(), response.sid);
                            FastLeaderElection.this.sendqueue.offer(notmsg);
                        }
                    }
                    catch (InterruptedException e) {
                        System.out.println("Interrupted Exception while waiting for new message" + e.toString());
                        continue;
                    }
                    break;
                }
            }
        }
    }

    public static class ToSend {
        long leader;
        long zxid;
        long epoch;
        QuorumPeer.ServerState state;
        long sid;

        ToSend(mType type, long leader, long zxid, long epoch, QuorumPeer.ServerState state, long sid) {
            this.leader = leader;
            this.zxid = zxid;
            this.epoch = epoch;
            this.state = state;
            this.sid = sid;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum mType {
            crequest,
            challenge,
            notification,
            ack;

        }
    }

    public static class Notification {
        long leader;
        long zxid;
        long epoch;
        QuorumPeer.ServerState state;
        long sid;
    }
}

