/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.jute.Record;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.txn.TxnHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Request {
    private static final Logger LOG = Logger.getLogger(Request.class);
    public static final Request requestOfDeath = new Request(null, 0L, 0, 0, null, null);
    public long sessionId;
    public int cxid;
    public int type;
    public ByteBuffer request;
    public ServerCnxn cnxn;
    public TxnHeader hdr;
    public Record txn;
    public long zxid = -1L;
    public List<Id> authInfo;
    public long createTime = System.currentTimeMillis();

    public Request(ServerCnxn cnxn, long sessionId, int xid, int type, ByteBuffer bb, List<Id> authInfo) {
        this.cnxn = cnxn;
        this.sessionId = sessionId;
        this.cxid = xid;
        this.type = type;
        this.request = bb;
        this.authInfo = authInfo;
    }

    static boolean isValid(int type) {
        switch (type) {
            case 0: {
                return false;
            }
            case -11: 
            case -10: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 101: {
                return true;
            }
        }
        return false;
    }

    static boolean isQuorum(int type) {
        switch (type) {
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                return false;
            }
            case -11: 
            case -10: 
            case -1: 
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    static String op2String(int op) {
        switch (op) {
            case 0: {
                return "notification";
            }
            case 1: {
                return "create";
            }
            case 101: {
                return "setWatches";
            }
            case 2: {
                return "delete";
            }
            case 3: {
                return "exists";
            }
            case 4: {
                return "getDate";
            }
            case 5: {
                return "setData";
            }
            case 9: {
                return "sync:";
            }
            case 6: {
                return "getACL";
            }
            case 7: {
                return "setACL";
            }
            case 8: {
                return "getChildren";
            }
            case 11: {
                return "ping";
            }
            case -10: {
                return "createSession";
            }
            case -11: {
                return "closeSession";
            }
            case -1: {
                return "error";
            }
        }
        return "unknown " + op;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("sessionid:0x").append(Long.toHexString(this.sessionId));
        sb.append(" type:").append(Request.op2String(this.type));
        sb.append(" cxid:0x").append(Long.toHexString(this.cxid));
        sb.append(" zxid:0x").append(Long.toHexString(this.hdr == null ? -2L : this.hdr.getZxid()));
        sb.append(" txntype:" + (this.hdr == null ? "unknown" : "" + this.hdr.getType()));
        sb.append(" ");
        String path = "n/a";
        if (this.type != -10 && this.request != null && this.request.remaining() >= 4) {
            try {
                this.request.clear();
                int pathLen = this.request.getInt();
                byte[] b = new byte[pathLen];
                this.request.get(b);
                path = new String(b);
                this.request.clear();
            }
            catch (Exception e) {
                LOG.warn((Object)"Ignoring exception during toString", (Throwable)e);
            }
        }
        sb.append(path).append(" ");
        return sb.toString();
    }
}

