/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.persistence.Util;

public class PurgeTxnLog {
    static void printUsage() {
        System.out.println("PurgeTxnLog dataLogDir [snapDir]");
        System.out.println("\tdataLogDir -- path to the txn log directory");
        System.out.println("\tsnapDir -- path to the snapshot directory");
        System.exit(1);
    }

    public static void main(String[] args) throws IOException {
        File dataDir;
        if (args.length < 1 || args.length > 2) {
            PurgeTxnLog.printUsage();
        }
        File snapDir = dataDir = new File(args[0]);
        if (args.length == 2) {
            snapDir = new File(args[1]);
        }
        FileTxnSnapLog txnLog = new FileTxnSnapLog(dataDir, snapDir);
        HashSet<File> exc = new HashSet<File>();
        File snapShot = txnLog.findMostRecentSnapshot();
        exc.add(txnLog.findMostRecentSnapshot());
        long zxid = Util.getZxidFromName(snapShot.getName(), "snapshot");
        exc.addAll(Arrays.asList(txnLog.getSnapshotLogs(zxid)));
        HashSet<File> exclude = exc;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MyFileFilter
        implements FileFilter {
            private final String prefix;
            final /* synthetic */ Set val$exclude;

            MyFileFilter(String string) {
                this.val$exclude = string;
                this.prefix = prefix;
            }

            @Override
            public boolean accept(File f) {
                return f.getName().startsWith(this.prefix) && !this.val$exclude.contains(f);
            }
        }
        ArrayList<File> files = new ArrayList<File>(Arrays.asList(dataDir.listFiles(new MyFileFilter("log.", exclude))));
        files.addAll(Arrays.asList(snapDir.listFiles(new MyFileFilter("snapshot.", exclude))));
        for (File f : files) {
            System.out.println("Removing file: " + DateFormat.getDateTimeInstance().format(f.lastModified()) + "\t" + f.getPath());
            if (f.delete()) continue;
            System.err.println("Failed to remove " + f.getPath());
        }
    }
}

