/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.jute.Record;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.proto.CreateResponse;
import org.apache.zookeeper.proto.ExistsRequest;
import org.apache.zookeeper.proto.ExistsResponse;
import org.apache.zookeeper.proto.GetACLRequest;
import org.apache.zookeeper.proto.GetACLResponse;
import org.apache.zookeeper.proto.GetChildrenRequest;
import org.apache.zookeeper.proto.GetChildrenResponse;
import org.apache.zookeeper.proto.GetDataRequest;
import org.apache.zookeeper.proto.GetDataResponse;
import org.apache.zookeeper.proto.ReplyHeader;
import org.apache.zookeeper.proto.SetACLResponse;
import org.apache.zookeeper.proto.SetDataResponse;
import org.apache.zookeeper.proto.SetWatches;
import org.apache.zookeeper.proto.SyncRequest;
import org.apache.zookeeper.proto.SyncResponse;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.PrepRequestProcessor;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.ServerStats;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.txn.CreateSessionTxn;
import org.apache.zookeeper.txn.ErrorTxn;

public class FinalRequestProcessor
implements RequestProcessor {
    private static final Logger LOG = Logger.getLogger(FinalRequestProcessor.class);
    ZooKeeperServer zks;

    public FinalRequestProcessor(ZooKeeperServer zks) {
        this.zks = zks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(Request request) {
        NIOServerCnxn.Factory scxn;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing request:: " + request));
        }
        long traceMask = 2L;
        if (request.type == 11) {
            traceMask = 128L;
        }
        ZooTrace.logRequest(LOG, traceMask, 'E', request, "");
        DataTree.ProcessTxnResult rc = null;
        List<ZooKeeperServer.ChangeRecord> list = this.zks.outstandingChanges;
        synchronized (list) {
            while (!this.zks.outstandingChanges.isEmpty() && this.zks.outstandingChanges.get((int)0).zxid <= request.zxid) {
                if (this.zks.outstandingChanges.get((int)0).zxid < request.zxid) {
                    LOG.warn((Object)("Zxid outstanding " + this.zks.outstandingChanges.get((int)0).zxid + " is less than current " + request.zxid));
                }
                this.zks.outstandingChanges.remove(0);
            }
            if (request.hdr != null) {
                rc = this.zks.dataTree.processTxn(request.hdr, request.txn);
                if (request.type == -10) {
                    if (request.txn instanceof CreateSessionTxn) {
                        CreateSessionTxn cst = (CreateSessionTxn)request.txn;
                        this.zks.sessionTracker.addSession(request.sessionId, cst.getTimeOut());
                    } else {
                        LOG.warn((Object)("*****>>>>> Got " + request.txn.getClass() + " " + request.txn.toString()));
                    }
                } else if (request.type == -11) {
                    this.zks.sessionTracker.removeSession(request.sessionId);
                }
            }
            if (Request.isQuorum(request.type)) {
                this.zks.addCommittedProposal(request);
            }
        }
        if (request.hdr != null && request.hdr.getType() == -11 && (scxn = this.zks.getServerCnxnFactory()) != null) {
            scxn.closeSession(request.sessionId);
        }
        if (request.cnxn == null) {
            return;
        }
        this.zks.decInProcess();
        int err = 0;
        Record rsp = null;
        try {
            if (request.hdr != null && request.hdr.getType() == -1) {
                throw KeeperException.create(((ErrorTxn)request.txn).getErr());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)request);
            }
            switch (request.type) {
                case 11: {
                    request.cnxn.sendResponse(new ReplyHeader(-2, this.zks.dataTree.lastProcessedZxid, 0), null, "response");
                    return;
                }
                case -10: {
                    request.cnxn.finishSessionInit(true);
                    return;
                }
                case 1: {
                    rsp = new CreateResponse(rc.path);
                    err = rc.err;
                    break;
                }
                case 2: {
                    err = rc.err;
                    break;
                }
                case 5: {
                    rsp = new SetDataResponse(rc.stat);
                    err = rc.err;
                    break;
                }
                case 7: {
                    rsp = new SetACLResponse(rc.stat);
                    err = rc.err;
                    break;
                }
                case -11: {
                    err = rc.err;
                    break;
                }
                case 9: {
                    SyncRequest syncRequest = new SyncRequest();
                    ZooKeeperServer.byteBuffer2Record(request.request, syncRequest);
                    rsp = new SyncResponse(syncRequest.getPath());
                    break;
                }
                case 3: {
                    ExistsRequest existsRequest = new ExistsRequest();
                    ZooKeeperServer.byteBuffer2Record(request.request, existsRequest);
                    String path = existsRequest.getPath();
                    if (path.indexOf(0) != -1) {
                        throw new KeeperException.BadArgumentsException();
                    }
                    Stat stat = this.zks.dataTree.statNode(path, existsRequest.getWatch() ? request.cnxn : null);
                    rsp = new ExistsResponse(stat);
                    break;
                }
                case 4: {
                    GetDataRequest getDataRequest = new GetDataRequest();
                    ZooKeeperServer.byteBuffer2Record(request.request, getDataRequest);
                    DataNode n = this.zks.dataTree.getNode(getDataRequest.getPath());
                    if (n == null) {
                        throw new KeeperException.NoNodeException();
                    }
                    PrepRequestProcessor.checkACL(this.zks, this.zks.dataTree.convertLong(n.acl), 1, request.authInfo);
                    Stat stat = new Stat();
                    byte[] b = this.zks.dataTree.getData(getDataRequest.getPath(), stat, getDataRequest.getWatch() ? request.cnxn : null);
                    rsp = new GetDataResponse(b, stat);
                    break;
                }
                case 101: {
                    SetWatches setWatches = new SetWatches();
                    request.request.rewind();
                    ZooKeeperServer.byteBuffer2Record(request.request, setWatches);
                    long relativeZxid = setWatches.getRelativeZxid();
                    this.zks.dataTree.setWatches(relativeZxid, setWatches.getDataWatches(), setWatches.getExistWatches(), setWatches.getChildWatches(), request.cnxn);
                    break;
                }
                case 6: {
                    GetACLRequest getACLRequest = new GetACLRequest();
                    ZooKeeperServer.byteBuffer2Record(request.request, getACLRequest);
                    Stat stat = new Stat();
                    List<ACL> acl = this.zks.dataTree.getACL(getACLRequest.getPath(), stat);
                    rsp = new GetACLResponse(acl, stat);
                    break;
                }
                case 8: {
                    GetChildrenRequest getChildrenRequest = new GetChildrenRequest();
                    ZooKeeperServer.byteBuffer2Record(request.request, getChildrenRequest);
                    Stat stat = new Stat();
                    DataNode n = this.zks.dataTree.getNode(getChildrenRequest.getPath());
                    if (n == null) {
                        throw new KeeperException.NoNodeException();
                    }
                    PrepRequestProcessor.checkACL(this.zks, this.zks.dataTree.convertLong(n.acl), 1, request.authInfo);
                    List<String> children = this.zks.dataTree.getChildren(getChildrenRequest.getPath(), stat, getChildrenRequest.getWatch() ? request.cnxn : null);
                    rsp = new GetChildrenResponse(children);
                }
            }
        }
        catch (KeeperException e) {
            err = e.getCode();
        }
        catch (Exception e) {
            LOG.warn((Object)("****************************** " + request));
            StringBuffer sb = new StringBuffer();
            ByteBuffer bb = request.request;
            bb.rewind();
            while (bb.hasRemaining()) {
                sb.append(Integer.toHexString(bb.get() & 0xFF));
            }
            LOG.warn((Object)sb.toString());
            LOG.error((Object)"FIXMSG", (Throwable)e);
            err = -5;
        }
        ReplyHeader hdr = new ReplyHeader(request.cxid, request.zxid, err);
        ServerStats.getInstance().updateLatency(request.createTime);
        try {
            request.cnxn.sendResponse(hdr, rsp, "response");
        }
        catch (IOException e) {
            LOG.error((Object)"FIXMSG", (Throwable)e);
        }
    }

    public void shutdown() {
        LOG.info((Object)"shutdown of request processor complete");
    }
}

