/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jute.Index;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.data.StatPersisted;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.WatchManager;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.txn.CreateTxn;
import org.apache.zookeeper.txn.DeleteTxn;
import org.apache.zookeeper.txn.ErrorTxn;
import org.apache.zookeeper.txn.SetACLTxn;
import org.apache.zookeeper.txn.SetDataTxn;
import org.apache.zookeeper.txn.TxnHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTree {
    private static final Logger LOG = Logger.getLogger(DataTree.class);
    private ConcurrentHashMap<String, DataNode> nodes = new ConcurrentHashMap();
    private WatchManager dataWatches = new WatchManager();
    private WatchManager childWatches = new WatchManager();
    private Map<Long, HashSet<String>> ephemerals = new ConcurrentHashMap<Long, HashSet<String>>();
    public Map<Long, List<ACL>> longKeyMap = new HashMap<Long, List<ACL>>();
    public Map<List<ACL>, Long> aclKeyMap = new HashMap<List<ACL>, Long>();
    protected long aclIndex = 0L;
    private String debug = "debug";
    private DataNode root = new DataNode(null, new byte[0], -1L, new StatPersisted());
    public volatile long lastProcessedZxid = 0L;
    int scount;
    public boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<String> getEphemerals(long sessionId) {
        HashSet<String> retv = this.ephemerals.get(sessionId);
        if (retv == null) {
            return new HashSet<String>();
        }
        HashSet cloned = null;
        HashSet<String> hashSet = retv;
        synchronized (hashSet) {
            cloned = (HashSet)retv.clone();
        }
        return cloned;
    }

    public Map<Long, HashSet<String>> getEphemeralsMap() {
        return this.ephemerals;
    }

    public void setEphemerals(Map<Long, HashSet<String>> ephemerals) {
        this.ephemerals = ephemerals;
    }

    private long incrementIndex() {
        return ++this.aclIndex;
    }

    private boolean listACLEquals(List<ACL> lista, List<ACL> listb) {
        if (lista.size() != listb.size()) {
            return false;
        }
        for (int i = 0; i < lista.size(); ++i) {
            ACL b;
            ACL a = lista.get(i);
            if (a.equals(b = listb.get(i))) continue;
            return false;
        }
        return true;
    }

    public synchronized Long convertAcls(List<ACL> acls) {
        if (acls == null) {
            return -1L;
        }
        Long ret = this.aclKeyMap.get(acls);
        if (ret != null) {
            return ret;
        }
        long val = this.incrementIndex();
        this.longKeyMap.put(val, acls);
        this.aclKeyMap.put(acls, val);
        return val;
    }

    public synchronized List<ACL> convertLong(Long longVal) {
        if (longVal == null || longVal == -1L) {
            return null;
        }
        List<ACL> acls = this.longKeyMap.get(longVal);
        if (acls == null) {
            LOG.error((Object)("ERROR: ACL not available for long " + longVal));
            throw new RuntimeException("Failed to fetch acls for " + longVal);
        }
        return acls;
    }

    public Collection<Long> getSessions() {
        return this.ephemerals.keySet();
    }

    public void addDataNode(String path, DataNode node) {
        this.nodes.put(path, node);
    }

    public DataNode getNode(String path) {
        return this.nodes.get(path);
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public int getWatchCount() {
        return this.dataWatches.size() + this.childWatches.size();
    }

    public DataTree() {
        this.nodes.put("", this.root);
        this.nodes.put("/", this.root);
    }

    public static void copyStatPersisted(StatPersisted from, StatPersisted to) {
        to.setAversion(from.getAversion());
        to.setCtime(from.getCtime());
        to.setCversion(from.getCversion());
        to.setCzxid(from.getCzxid());
        to.setMtime(from.getMtime());
        to.setMzxid(from.getMzxid());
        to.setPzxid(from.getPzxid());
        to.setVersion(from.getVersion());
        to.setEphemeralOwner(from.getEphemeralOwner());
    }

    public static void copyStat(Stat from, Stat to) {
        to.setAversion(from.getAversion());
        to.setCtime(from.getCtime());
        to.setCversion(from.getCversion());
        to.setCzxid(from.getCzxid());
        to.setMtime(from.getMtime());
        to.setMzxid(from.getMzxid());
        to.setPzxid(from.getPzxid());
        to.setVersion(from.getVersion());
        to.setEphemeralOwner(from.getEphemeralOwner());
        to.setDataLength(from.getDataLength());
        to.setNumChildren(from.getNumChildren());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createNode(String path, byte[] data, List<ACL> acl, long ephemeralOwner, long zxid, long time) throws KeeperException.NoNodeException, KeeperException.NodeExistsException {
        int lastSlash = path.lastIndexOf(47);
        String parentName = path.substring(0, lastSlash);
        String childName = path.substring(lastSlash + 1);
        StatPersisted stat = new StatPersisted();
        stat.setCtime(time);
        stat.setMtime(time);
        stat.setCzxid(zxid);
        stat.setMzxid(zxid);
        stat.setPzxid(zxid);
        stat.setVersion(0);
        stat.setAversion(0);
        stat.setEphemeralOwner(ephemeralOwner);
        DataNode parent = this.nodes.get(parentName);
        if (parent == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = parent;
        synchronized (dataNode) {
            if (parent.children.contains(childName)) {
                throw new KeeperException.NodeExistsException();
            }
            int cver = parent.stat.getCversion();
            parent.stat.setCversion(++cver);
            parent.stat.setPzxid(zxid);
            Long longval = this.convertAcls(acl);
            DataNode child = new DataNode(parent, data, longval, stat);
            parent.children.add(childName);
            this.nodes.put(path, child);
            if (ephemeralOwner != 0L) {
                HashSet<String> list = this.ephemerals.get(ephemeralOwner);
                if (list == null) {
                    list = new HashSet();
                    this.ephemerals.put(ephemeralOwner, list);
                }
                HashSet<String> hashSet = list;
                synchronized (hashSet) {
                    list.add(path);
                }
            }
        }
        this.dataWatches.triggerWatch(path, Watcher.Event.EventType.NodeCreated);
        this.childWatches.triggerWatch(parentName.equals("") ? "/" : parentName, Watcher.Event.EventType.NodeChildrenChanged);
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNode(String path, long zxid) throws KeeperException.NoNodeException {
        int lastSlash = path.lastIndexOf(47);
        String parentName = path.substring(0, lastSlash);
        String childName = path.substring(lastSlash + 1);
        DataNode node = this.nodes.get(path);
        if (node == null) {
            throw new KeeperException.NoNodeException();
        }
        this.nodes.remove(path);
        DataNode parent = this.nodes.get(parentName);
        if (parent == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = parent;
        synchronized (dataNode) {
            HashSet<String> nodes;
            parent.children.remove(childName);
            parent.stat.setCversion(parent.stat.getCversion() + 1);
            parent.stat.setPzxid(zxid);
            long eowner = node.stat.getEphemeralOwner();
            if (eowner != 0L && (nodes = this.ephemerals.get(eowner)) != null) {
                HashSet<String> hashSet = nodes;
                synchronized (hashSet) {
                    nodes.remove(path);
                }
            }
            node.parent = null;
        }
        ZooTrace.logTraceMessage(LOG, 64L, "dataWatches.triggerWatch " + path);
        ZooTrace.logTraceMessage(LOG, 64L, "childWatches.triggerWatch " + parentName);
        Set<Watcher> processed = this.dataWatches.triggerWatch(path, Watcher.Event.EventType.NodeDeleted);
        this.childWatches.triggerWatch(path, Watcher.Event.EventType.NodeDeleted, processed);
        this.childWatches.triggerWatch(parentName.equals("") ? "/" : parentName, Watcher.Event.EventType.NodeChildrenChanged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat setData(String path, byte[] data, int version, long zxid, long time) throws KeeperException.NoNodeException {
        Stat s = new Stat();
        DataNode n = this.nodes.get(path);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            n.data = data;
            n.stat.setMtime(time);
            n.stat.setMzxid(zxid);
            n.stat.setVersion(version);
            n.copyStat(s);
        }
        this.dataWatches.triggerWatch(path, Watcher.Event.EventType.NodeDataChanged);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData(String path, Stat stat, Watcher watcher) throws KeeperException.NoNodeException {
        DataNode n = this.nodes.get(path);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            n.copyStat(stat);
            if (watcher != null) {
                this.dataWatches.addWatch(path, watcher);
            }
            return n.data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat statNode(String path, Watcher watcher) throws KeeperException.NoNodeException {
        Stat stat = new Stat();
        DataNode n = this.nodes.get(path);
        if (watcher != null) {
            this.dataWatches.addWatch(path, watcher);
        }
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            n.copyStat(stat);
            return stat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getChildren(String path, Stat stat, Watcher watcher) throws KeeperException.NoNodeException {
        DataNode n = this.nodes.get(path);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            ArrayList<String> children = new ArrayList<String>();
            children.addAll(n.children);
            if (watcher != null) {
                this.childWatches.addWatch(path, watcher);
            }
            return children;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat setACL(String path, List<ACL> acl, int version) throws KeeperException.NoNodeException {
        Stat stat = new Stat();
        DataNode n = this.nodes.get(path);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            n.stat.setAversion(version);
            n.acl = this.convertAcls(acl);
            n.copyStat(stat);
            return stat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ACL> getACL(String path, Stat stat) throws KeeperException.NoNodeException {
        DataNode n = this.nodes.get(path);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            n.copyStat(stat);
            return new ArrayList<ACL>(this.convertLong(n.acl));
        }
    }

    public ProcessTxnResult processTxn(TxnHeader header, Record txn) {
        ProcessTxnResult rc;
        block11: {
            rc = new ProcessTxnResult();
            try {
                rc.clientId = header.getClientId();
                rc.cxid = header.getCxid();
                rc.zxid = header.getZxid();
                rc.type = header.getType();
                rc.err = 0;
                if (rc.zxid > this.lastProcessedZxid) {
                    this.lastProcessedZxid = rc.zxid;
                }
                switch (header.getType()) {
                    case 1: {
                        CreateTxn createTxn = (CreateTxn)txn;
                        this.debug = "Create transaction for " + createTxn.getPath();
                        this.createNode(createTxn.getPath(), createTxn.getData(), createTxn.getAcl(), createTxn.getEphemeral() ? header.getClientId() : 0L, header.getZxid(), header.getTime());
                        rc.path = createTxn.getPath();
                        break;
                    }
                    case 2: {
                        DeleteTxn deleteTxn = (DeleteTxn)txn;
                        this.debug = "Delete transaction for " + deleteTxn.getPath();
                        this.deleteNode(deleteTxn.getPath(), header.getZxid());
                        break;
                    }
                    case 5: {
                        SetDataTxn setDataTxn = (SetDataTxn)txn;
                        this.debug = "Set data for  transaction for " + setDataTxn.getPath();
                        rc.stat = this.setData(setDataTxn.getPath(), setDataTxn.getData(), setDataTxn.getVersion(), header.getZxid(), header.getTime());
                        break;
                    }
                    case 7: {
                        SetACLTxn setACLTxn = (SetACLTxn)txn;
                        rc.stat = this.setACL(setACLTxn.getPath(), setACLTxn.getAcl(), setACLTxn.getVersion());
                        break;
                    }
                    case -11: {
                        this.killSession(header.getClientId(), header.getZxid());
                        break;
                    }
                    case -1: {
                        ErrorTxn errTxn = (ErrorTxn)txn;
                        rc.err = errTxn.getErr();
                    }
                }
            }
            catch (KeeperException e) {
                if (!this.initialized && (e.getCode() == -101 || e.getCode() == -110)) break block11;
                LOG.warn((Object)this.debug);
                LOG.error((Object)"FIXMSG", (Throwable)e);
            }
        }
        return rc;
    }

    void killSession(long session, long zxid) {
        HashSet<String> list = this.ephemerals.remove(session);
        if (list != null) {
            for (String path : list) {
                try {
                    this.deleteNode(path, zxid);
                    ZooTrace.logTraceMessage(LOG, 32L, "Deleting ephemeral node " + path + " for session 0x" + Long.toHexString(session));
                }
                catch (KeeperException e) {
                    LOG.error((Object)"FIXMSG", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serializeNode(OutputArchive oa, StringBuilder path) throws IOException {
        String pathString = path.toString();
        DataNode node = this.getNode(pathString);
        if (node == null) {
            return;
        }
        String[] children = null;
        DataNode dataNode = node;
        synchronized (dataNode) {
            ++this.scount;
            oa.writeString(pathString, "path");
            oa.writeRecord(node, "node");
            children = node.children.toArray(new String[node.children.size()]);
        }
        path.append('/');
        int off = path.length();
        if (children != null) {
            for (String child : children) {
                path.delete(off, Integer.MAX_VALUE);
                path.append(child);
                this.serializeNode(oa, path);
            }
        }
    }

    private void deserializeList(Map<Long, List<ACL>> longKeyMap, InputArchive ia) throws IOException {
        for (int i = ia.readInt("map"); i > 0; --i) {
            Long val = ia.readLong("long");
            if (this.aclIndex < val) {
                this.aclIndex = val;
            }
            ArrayList<ACL> aclList = new ArrayList<ACL>();
            Index j = ia.startVector("acls");
            while (!j.done()) {
                ACL acl = new ACL();
                acl.deserialize(ia, "acl");
                aclList.add(acl);
                j.incr();
            }
            longKeyMap.put(val, aclList);
            this.aclKeyMap.put(aclList, val);
        }
    }

    private synchronized void serializeList(Map<Long, List<ACL>> longKeyMap, OutputArchive oa) throws IOException {
        oa.writeInt(longKeyMap.size(), "map");
        Set<Map.Entry<Long, List<ACL>>> set = longKeyMap.entrySet();
        for (Map.Entry<Long, List<ACL>> val : set) {
            oa.writeLong(val.getKey(), "long");
            List<ACL> aclList = val.getValue();
            oa.startVector(aclList, "acls");
            for (ACL acl : aclList) {
                acl.serialize(oa, "acl");
            }
            oa.endVector(aclList, "acls");
        }
    }

    public void serialize(OutputArchive oa, String tag) throws IOException {
        this.scount = 0;
        this.serializeList(this.longKeyMap, oa);
        this.serializeNode(oa, new StringBuilder(""));
        if (this.root != null) {
            oa.writeString("/", "path");
        }
    }

    public void deserialize(InputArchive ia, String tag) throws IOException {
        this.deserializeList(this.longKeyMap, ia);
        this.nodes.clear();
        String path = ia.readString("path");
        while (!path.equals("/")) {
            DataNode node = new DataNode();
            ia.readRecord(node, "node");
            this.nodes.put(path, node);
            int lastSlash = path.lastIndexOf(47);
            if (lastSlash == -1) {
                this.root = node;
            } else {
                String parentPath = path.substring(0, lastSlash);
                node.parent = this.nodes.get(parentPath);
                node.parent.children.add(path.substring(lastSlash + 1));
                long eowner = node.stat.getEphemeralOwner();
                if (eowner != 0L) {
                    HashSet<String> list = this.ephemerals.get(eowner);
                    if (list == null) {
                        list = new HashSet();
                        this.ephemerals.put(eowner, list);
                    }
                    list.add(path);
                }
            }
            path = ia.readString("path");
        }
        this.nodes.put("/", this.root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpEphemerals() {
        Set<Long> keys = this.ephemerals.keySet();
        StringBuffer sb = new StringBuffer("Sessions with Ephemerals (" + keys.size() + "):\n");
        for (long k : keys) {
            HashSet<String> tmp;
            sb.append("0x" + Long.toHexString(k));
            sb.append(":\n");
            HashSet<String> hashSet = tmp = this.ephemerals.get(k);
            synchronized (hashSet) {
                for (String path : tmp) {
                    sb.append("\t" + path + "\n");
                }
            }
        }
        return sb.toString();
    }

    public void removeCnxn(Watcher watcher) {
        this.dataWatches.removeWatcher(watcher);
        this.childWatches.removeWatcher(watcher);
    }

    public void clear() {
        this.root = null;
        this.nodes.clear();
        this.ephemerals.clear();
    }

    public void setWatches(long relativeZxid, List<String> dataWatches, List<String> existWatches, List<String> childWatches, Watcher watcher) {
        WatchedEvent e;
        DataNode node;
        for (String path : dataWatches) {
            node = this.getNode(path);
            e = null;
            if (node == null) {
                e = new WatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, path);
            } else if (node.stat.getCzxid() > relativeZxid) {
                e = new WatchedEvent(Watcher.Event.EventType.NodeCreated, Watcher.Event.KeeperState.SyncConnected, path);
            } else if (node.stat.getMzxid() > relativeZxid) {
                e = new WatchedEvent(Watcher.Event.EventType.NodeDataChanged, Watcher.Event.KeeperState.SyncConnected, path);
            }
            if (e != null) {
                watcher.process(e);
                continue;
            }
            this.dataWatches.addWatch(path, watcher);
        }
        for (String path : existWatches) {
            node = this.getNode(path);
            e = null;
            if (node != null) {
                e = node.stat.getMzxid() > relativeZxid ? new WatchedEvent(Watcher.Event.EventType.NodeDataChanged, Watcher.Event.KeeperState.SyncConnected, path) : new WatchedEvent(Watcher.Event.EventType.NodeCreated, Watcher.Event.KeeperState.SyncConnected, path);
            }
            if (e != null) {
                watcher.process(e);
                continue;
            }
            this.dataWatches.addWatch(path, watcher);
        }
        for (String path : childWatches) {
            node = this.getNode(path);
            e = null;
            if (node == null) {
                e = new WatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, path);
            } else if (node.stat.getPzxid() > relativeZxid) {
                e = new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, path);
            }
            if (e != null) {
                watcher.process(e);
                continue;
            }
            this.childWatches.addWatch(path, watcher);
        }
    }

    public static class ProcessTxnResult {
        public long clientId;
        public int cxid;
        public long zxid;
        public int err;
        public int type;
        public String path;
        public Stat stat;

        public boolean equals(Object o) {
            if (o instanceof ProcessTxnResult) {
                ProcessTxnResult other = (ProcessTxnResult)o;
                return other.clientId == this.clientId && other.cxid == this.cxid;
            }
            return false;
        }

        public int hashCode() {
            return (int)((this.clientId ^ (long)this.cxid) % Integer.MAX_VALUE);
        }
    }
}

