/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.IOException;
import java.util.HashSet;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.data.StatPersisted;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataNode
implements Record {
    DataNode parent;
    byte[] data;
    Long acl;
    public StatPersisted stat;
    HashSet<String> children = new HashSet();

    DataNode() {
    }

    public DataNode(DataNode parent, byte[] data, Long acl, StatPersisted stat) {
        this.parent = parent;
        this.data = data;
        this.acl = acl;
        this.stat = stat;
        this.children = new HashSet();
    }

    public void setChildren(HashSet<String> children) {
        this.children = children;
    }

    public HashSet<String> getChildren() {
        return this.children;
    }

    public void copyStat(Stat to) {
        to.setAversion(this.stat.getAversion());
        to.setCtime(this.stat.getCtime());
        to.setCversion(this.stat.getCversion());
        to.setCzxid(this.stat.getCzxid());
        to.setMtime(this.stat.getMtime());
        to.setMzxid(this.stat.getMzxid());
        to.setPzxid(this.stat.getPzxid());
        to.setVersion(this.stat.getVersion());
        to.setEphemeralOwner(this.stat.getEphemeralOwner());
        to.setDataLength(this.data.length);
        to.setNumChildren(this.children.size());
    }

    @Override
    public void deserialize(InputArchive archive, String tag) throws IOException {
        archive.startRecord("node");
        this.data = archive.readBuffer("data");
        this.acl = archive.readLong("acl");
        this.stat = new StatPersisted();
        this.stat.deserialize(archive, "statpersisted");
        archive.endRecord("node");
    }

    @Override
    public synchronized void serialize(OutputArchive archive, String tag) throws IOException {
        archive.startRecord(this, "node");
        archive.writeBuffer(this.data, "data");
        archive.writeLong(this.acl, "acl");
        this.stat.serialize(archive, "statpersisted");
        archive.endRecord(this, "node");
    }

    public int compareTo(Object o) {
        return -1;
    }
}

