/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

public abstract class KeeperException
extends Exception {
    private int code;
    private String path;

    public static KeeperException create(int code, String path) {
        KeeperException r = KeeperException.create(code);
        r.path = path;
        return r;
    }

    public static KeeperException create(int code) {
        switch (code) {
            case -1: {
                return new SystemErrorException();
            }
            case -2: {
                return new RuntimeInconsistencyException();
            }
            case -3: {
                return new DataInconsistencyException();
            }
            case -4: {
                return new ConnectionLossException();
            }
            case -5: {
                return new MarshallingErrorException();
            }
            case -6: {
                return new UnimplementedException();
            }
            case -7: {
                return new OperationTimeoutException();
            }
            case -8: {
                return new BadArgumentsException();
            }
            case -100: {
                return new APIErrorException();
            }
            case -101: {
                return new NoNodeException();
            }
            case -102: {
                return new NoAuthException();
            }
            case -103: {
                return new BadVersionException();
            }
            case -108: {
                return new NoChildrenForEphemeralsException();
            }
            case -110: {
                return new NodeExistsException();
            }
            case -114: {
                return new InvalidACLException();
            }
            case -115: {
                return new AuthFailedException();
            }
            case -111: {
                return new NotEmptyException();
            }
            case -112: {
                return new SessionExpiredException();
            }
            case -113: {
                return new InvalidCallbackException();
            }
        }
        throw new IllegalArgumentException("Invalid exception code");
    }

    public void setCode(int code) {
        this.code = code;
    }

    static String getCodeMessage(int code) {
        switch (code) {
            case 0: {
                return "ok";
            }
            case -1: {
                return "SystemError";
            }
            case -2: {
                return "RuntimeInconsistency";
            }
            case -3: {
                return "DataInconsistency";
            }
            case -4: {
                return "ConnectionLoss";
            }
            case -5: {
                return "MarshallingError";
            }
            case -6: {
                return "Unimplemented";
            }
            case -7: {
                return "OperationTimeout";
            }
            case -8: {
                return "BadArguments";
            }
            case -100: {
                return "APIError";
            }
            case -101: {
                return "NoNode";
            }
            case -102: {
                return "NoAuth";
            }
            case -103: {
                return "BadVersion";
            }
            case -108: {
                return "NoChildrenForEphemerals";
            }
            case -110: {
                return "NodeExists";
            }
            case -114: {
                return "InvalidACL";
            }
            case -115: {
                return "AuthFailed";
            }
            case -111: {
                return "Directory not empty";
            }
            case -112: {
                return "Session expired";
            }
            case -113: {
                return "Invalid callback";
            }
        }
        return "Unknown error " + code;
    }

    public KeeperException(int code) {
        this.code = code;
    }

    KeeperException(int code, String path) {
        this.code = code;
        this.path = path;
    }

    public int getCode() {
        return this.code;
    }

    public String getPath() {
        return this.path;
    }

    public String getMessage() {
        if (this.path == null) {
            return "KeeperErrorCode = " + KeeperException.getCodeMessage(this.code);
        }
        return "KeeperErrorCode = " + KeeperException.getCodeMessage(this.code) + " for " + this.path;
    }

    public static class UnimplementedException
    extends KeeperException {
        public UnimplementedException() {
            super(-6);
        }
    }

    public static class SystemErrorException
    extends KeeperException {
        public SystemErrorException() {
            super(-1);
        }
    }

    public static class SessionExpiredException
    extends KeeperException {
        public SessionExpiredException() {
            super(-112);
        }
    }

    public static class RuntimeInconsistencyException
    extends KeeperException {
        public RuntimeInconsistencyException() {
            super(-2);
        }
    }

    public static class OperationTimeoutException
    extends KeeperException {
        public OperationTimeoutException() {
            super(-7);
        }
    }

    public static class NotEmptyException
    extends KeeperException {
        public NotEmptyException() {
            super(-111);
        }
    }

    public static class NoNodeException
    extends KeeperException {
        public NoNodeException() {
            super(-101);
        }
    }

    public static class NodeExistsException
    extends KeeperException {
        public NodeExistsException() {
            super(-110);
        }
    }

    public static class NoChildrenForEphemeralsException
    extends KeeperException {
        public NoChildrenForEphemeralsException() {
            super(-108);
        }
    }

    public static class NoAuthException
    extends KeeperException {
        public NoAuthException() {
            super(-102);
        }
    }

    public static class MarshallingErrorException
    extends KeeperException {
        public MarshallingErrorException() {
            super(-5);
        }
    }

    public static class InvalidCallbackException
    extends KeeperException {
        public InvalidCallbackException() {
            super(-113);
        }
    }

    public static class InvalidACLException
    extends KeeperException {
        public InvalidACLException() {
            super(-114);
        }
    }

    public static class DataInconsistencyException
    extends KeeperException {
        public DataInconsistencyException() {
            super(-3);
        }
    }

    public static class ConnectionLossException
    extends KeeperException {
        public ConnectionLossException() {
            super(-4);
        }
    }

    public static class BadVersionException
    extends KeeperException {
        public BadVersionException() {
            super(-103);
        }
    }

    public static class BadArgumentsException
    extends KeeperException {
        public BadArgumentsException() {
            super(-8);
        }
    }

    public static class AuthFailedException
    extends KeeperException {
        public AuthFailedException() {
            super(-115);
        }
    }

    public static class APIErrorException
    extends KeeperException {
        public APIErrorException() {
            super(-100);
        }
    }

    public static interface Code {
        public static final int Ok = 0;
        public static final int SystemError = -1;
        public static final int RuntimeInconsistency = -2;
        public static final int DataInconsistency = -3;
        public static final int ConnectionLoss = -4;
        public static final int MarshallingError = -5;
        public static final int Unimplemented = -6;
        public static final int OperationTimeout = -7;
        public static final int BadArguments = -8;
        public static final int APIError = -100;
        public static final int NoNode = -101;
        public static final int NoAuth = -102;
        public static final int BadVersion = -103;
        public static final int NoChildrenForEphemerals = -108;
        public static final int NodeExists = -110;
        public static final int NotEmpty = -111;
        public static final int SessionExpired = -112;
        public static final int InvalidCallback = -113;
        public static final int InvalidACL = -114;
        public static final int AuthFailed = -115;
    }
}

