/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.util.URIParserUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Stax2DOM {
    private Element currentElement;
    private Document doc;
    private XMLInputFactory factory;
    private XMLEventReader reader;

    private void init() {
        try {
            this.factory = XMLInputFactory.newInstance();
            this.factory.setProperty("javax.xml.stream.isNamespaceAware", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ToolException((Throwable)e);
        }
    }

    public Document getDocument(String wsdl) throws ToolException {
        try {
            URI wsdlURI = new URI(URIParserUtil.getAbsoluteURI((String)wsdl));
            if (wsdlURI.toString().startsWith("http")) {
                return this.getDocument(wsdlURI.toURL());
            }
            return this.getDocument(wsdlURI.toURL());
        }
        catch (Exception e) {
            throw new ToolException((Throwable)e);
        }
    }

    public Document getDocument(URL url) throws ToolException {
        if (this.reader == null) {
            this.init();
            try {
                this.reader = this.factory.createXMLEventReader(url.openStream());
            }
            catch (FileNotFoundException fe) {
                throw new ToolException("Cannot get the wsdl " + url, (Throwable)fe);
            }
            catch (XMLStreamException e) {
                throw new ToolException((Throwable)e);
            }
            catch (IOException ioe) {
                throw new ToolException((Throwable)ioe);
            }
        }
        return this.getDocument(this.reader, url.toString());
    }

    public Document getDocument(File wsdl) throws ToolException {
        if (this.reader == null) {
            this.init();
            try {
                this.reader = this.factory.createXMLEventReader(new FileReader(wsdl));
            }
            catch (FileNotFoundException fe) {
                throw new ToolException("Cannot get the wsdl " + wsdl, (Throwable)fe);
            }
            catch (XMLStreamException e) {
                throw new ToolException((Throwable)e);
            }
        }
        return this.getDocument(this.reader, wsdl.toString());
    }

    public Document getDocument(XMLEventReader xmlEventReader) throws ToolException {
        return this.getDocument(xmlEventReader, null);
    }

    public Document getDocument(XMLEventReader xmlEventReader, String wsdlurl) throws ToolException {
        try {
            this.doc = XMLUtils.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new ToolException((Throwable)e);
        }
        this.doc.setDocumentURI(wsdlurl);
        this.currentElement = this.doc.getDocumentElement();
        while (xmlEventReader.hasNext()) {
            XMLEvent xmleve = (XMLEvent)xmlEventReader.next();
            if (xmleve.getEventType() == 2) {
                this.endElement();
            }
            if (xmleve.getEventType() != 1) continue;
            this.startElement((StartElement)xmleve);
        }
        return this.doc;
    }

    public void startElement(StartElement ele) {
        Element element = null;
        element = this.doc.createElementNS(ele.getName().getNamespaceURI(), ele.getName().getLocalPart());
        Iterator<Attribute> ite = ele.getAttributes();
        while (ite.hasNext()) {
            Attribute attr = ite.next();
            element.setAttribute(attr.getName().getLocalPart(), attr.getValue());
        }
        String xmlns = "http://schemas.xmlsoap.org/wsdl/";
        ite = ele.getNamespaces();
        while (ite.hasNext()) {
            Namespace ns = (Namespace)ite.next();
            String name = ns.getPrefix();
            if (!StringUtils.isEmpty((String)name)) {
                element.setAttributeNS(xmlns, name, ns.getNamespaceURI());
                continue;
            }
            xmlns = ns.getNamespaceURI();
        }
        if (this.currentElement == null) {
            this.doc.appendChild(element);
        } else {
            this.currentElement.appendChild(element);
        }
        this.currentElement = element;
        element.setUserData("location", ele.getLocation(), null);
    }

    public void endElement() {
        Node node = this.currentElement.getParentNode();
        this.currentElement = node instanceof Document ? ((Document)node).getDocumentElement() : (Element)this.currentElement.getParentNode();
    }
}

