/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.tools.common.Tag;

public final class ToolsStaxUtils {
    private ToolsStaxUtils() {
    }

    public static Tag getTagTree(InputStream source) throws Exception {
        return ToolsStaxUtils.getTagTree(source, Collections.emptyList(), null);
    }

    public static Tag getTagTree(File source, Collection<String> ignoreAttr, Map<QName, Set<String>> types) throws Exception {
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(source.toPath(), new OpenOption[0]));){
            Tag tag = ToolsStaxUtils.getTagTree(is, ignoreAttr, types);
            return tag;
        }
    }

    public static Tag getTagTree(InputStream is, Collection<String> ignoreAttr, Map<QName, Set<String>> types) throws Exception {
        Tag root = new Tag();
        root.setName(new QName("root", "root"));
        XMLStreamReader reader = StaxUtils.createXMLStreamReader((InputStream)is);
        Tag newTag = null;
        Tag currentTag = root;
        while (reader.hasNext()) {
            int event = reader.next();
            if (event == 1) {
                newTag = new Tag();
                newTag.setName(reader.getName());
                if (!ignoreAttr.isEmpty()) {
                    newTag.getIgnoreAttr().addAll(ignoreAttr);
                }
                for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    Object tp = reader.getAttributeValue(i);
                    if (ToolsStaxUtils.isType(types, reader.getName(), reader.getAttributeName(i))) {
                        int idx = ((String)tp).indexOf(58);
                        if (idx > 0 && ((String)tp).length() > idx && ((String)tp).substring(idx + 1).indexOf(58) == -1) {
                            String pfx = ((String)tp).substring(0, idx);
                            String ns = reader.getNamespaceURI(pfx);
                            if (ns != null) {
                                tp = "{" + ns + "}" + ((String)tp).substring(idx + 1);
                            }
                        } else {
                            String ns = reader.getNamespaceURI("");
                            if (ns != null) {
                                tp = "{" + ns + "}" + ((String)tp).substring(idx + 1);
                            }
                        }
                    }
                    newTag.getAttributes().put(reader.getAttributeName(i), (String)tp);
                }
                newTag.setParent(currentTag);
                currentTag.getTags().add(newTag);
                currentTag = newTag;
                continue;
            }
            if (event == 4) {
                newTag.setText(reader.getText());
                continue;
            }
            if (event != 2) continue;
            currentTag = currentTag.getParent();
        }
        reader.close();
        return root;
    }

    private static boolean isType(Map<QName, Set<String>> types, QName name, QName attributeName) {
        if (types == null) {
            return false;
        }
        Set<String> a = types.get(name);
        return a != null && a.contains(attributeName.getLocalPart());
    }
}

