/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;

public final class TestFileUtils {
    private TestFileUtils() {
    }

    public static String getStringFromFile(File location) throws IOException {
        try (BufferedReader in = Files.newBufferedReader(location.toPath());){
            String string = TestFileUtils.normalizeCRLF(in);
            return string;
        }
    }

    public static String getStringFromStream(InputStream is) throws IOException {
        return TestFileUtils.normalizeCRLF(new BufferedReader(new InputStreamReader(is)));
    }

    private static String normalizeCRLF(BufferedReader in) throws IOException {
        StringBuilder result = new StringBuilder();
        String line = in.readLine();
        while (line != null) {
            for (String token : line.split("\\s")) {
                result.append(' ').append(token);
            }
            line = in.readLine();
        }
        String rtn = result.toString();
        rtn = TestFileUtils.ignoreTokens(rtn, "<!--", "-->");
        rtn = TestFileUtils.ignoreTokens(rtn, "/*", "*/");
        return rtn;
    }

    private static String ignoreTokens(String contents, String startToken, String endToken) {
        Object rtn = contents;
        int headerIndexStart = ((String)rtn).indexOf(startToken);
        int headerIndexEnd = ((String)rtn).indexOf(endToken);
        if (headerIndexStart != -1 && headerIndexEnd != -1 && headerIndexStart < headerIndexEnd) {
            rtn = ((String)rtn).substring(0, headerIndexStart - 1) + ((String)rtn).substring(headerIndexEnd + endToken.length() + 1);
        }
        return rtn;
    }
}

