/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.toolspec.parser;

import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.common.toolspec.parser.BadUsageException;
import org.apache.cxf.tools.common.toolspec.parser.CommandDocument;
import org.apache.cxf.tools.common.toolspec.parser.CommandLineError;
import org.apache.cxf.tools.common.toolspec.parser.CommandLineParser;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CommandLineParserTest {
    private CommandLineParser parser;

    @Before
    public void setUp() throws Exception {
        String tsSource = "/org/apache/cxf/tools/common/toolspec/parser/resources/testtool.xml";
        ToolSpec toolspec = new ToolSpec(this.getClass().getResourceAsStream(tsSource), true);
        this.parser = new CommandLineParser(toolspec);
    }

    @Test
    public void testValidArguments() throws Exception {
        String[] args = new String[]{"-r", "-n", "test", "arg1"};
        CommandDocument result = this.parser.parseArguments(args);
        Assert.assertEquals((String)"testValidArguments Failed", (Object)"test", (Object)result.getParameter("namespace"));
    }

    @Test
    public void testInvalidArgumentValue() throws Exception {
        try {
            String[] args = new String[]{"-n", "test@", "arg1"};
            this.parser.parseArguments(args);
            Assert.fail((String)"testInvalidArgumentValue failed");
        }
        catch (BadUsageException ex) {
            Object[] errors = ex.getErrors().toArray();
            Assert.assertEquals((String)"testInvalidArgumentValue failed", (long)1L, (long)errors.length);
            CommandLineError error = (CommandLineError)errors[0];
            Assert.assertTrue((String)"Expected InvalidArgumentValue error", (boolean)(error instanceof ErrorVisitor.UserError));
            ErrorVisitor.UserError userError = (ErrorVisitor.UserError)error;
            Assert.assertEquals((String)"Invalid argument value message incorrect", (Object)"-n has invalid character!", (Object)userError.toString());
        }
    }

    @Test
    public void testValidArgumentEnumValue() throws Exception {
        String[] args = new String[]{"-r", "-e", "true", "arg1"};
        CommandDocument result = this.parser.parseArguments(args);
        Assert.assertEquals((String)"testValidArguments Failed", (Object)"true", (Object)result.getParameter("enum"));
    }

    @Test
    public void testInvalidArgumentEnumValue() throws Exception {
        try {
            String[] args = new String[]{"-e", "wrongvalue"};
            this.parser.parseArguments(args);
            Assert.fail((String)"testInvalidArgumentEnumValue failed");
        }
        catch (BadUsageException ex) {
            Object[] errors = ex.getErrors().toArray();
            Assert.assertEquals((String)"testInvalidArgumentEnumValu failed", (long)1L, (long)errors.length);
            CommandLineError error = (CommandLineError)errors[0];
            Assert.assertTrue((String)"Expected InvalidArgumentEnumValu error", (boolean)(error instanceof ErrorVisitor.UserError));
            ErrorVisitor.UserError userError = (ErrorVisitor.UserError)error;
            Assert.assertEquals((String)"Invalid enum argument value message incorrect", (Object)"-e wrongvalue not in the enumeration value list!", (Object)userError.toString());
        }
    }

    @Test
    public void testValidMixedArguments() throws Exception {
        String[] args = new String[]{"-v", "-r", "-n", "test", "arg1"};
        CommandDocument result = this.parser.parseArguments(args);
        Assert.assertEquals((String)"testValidMissedArguments Failed", (Object)"test", (Object)result.getParameter("namespace"));
    }

    @Test
    public void testInvalidOption() throws IOException {
        try {
            String[] args = new String[]{"-n", "-r", "arg1"};
            this.parser.parseArguments(args);
            Assert.fail((String)"testInvalidOption failed");
        }
        catch (BadUsageException ex) {
            Object[] errors = ex.getErrors().toArray();
            Assert.assertEquals((String)"testInvalidOption failed", (long)1L, (long)errors.length);
            CommandLineError error = (CommandLineError)errors[0];
            Assert.assertTrue((String)"Expected InvalidOption error", (boolean)(error instanceof ErrorVisitor.InvalidOption));
            ErrorVisitor.InvalidOption option = (ErrorVisitor.InvalidOption)error;
            Assert.assertEquals((String)"Invalid option incorrect", (Object)"-n", (Object)option.getOptionSwitch());
            Assert.assertEquals((String)"Invalid option message incorrect", (Object)"Invalid option: -n is missing its associated argument", (Object)option.toString());
        }
    }

    @Test
    public void testMissingOption() throws IOException {
        try {
            String[] args = new String[]{"-n", "test", "arg1"};
            this.parser.parseArguments(args);
            Assert.fail((String)"testMissingOption failed");
        }
        catch (BadUsageException ex) {
            Object[] errors = ex.getErrors().toArray();
            Assert.assertEquals((String)"testInvalidOption failed", (long)1L, (long)errors.length);
            CommandLineError error = (CommandLineError)errors[0];
            Assert.assertTrue((String)"Expected MissingOption error", (boolean)(error instanceof ErrorVisitor.MissingOption));
            ErrorVisitor.MissingOption option = (ErrorVisitor.MissingOption)error;
            Assert.assertEquals((String)"Missing option incorrect", (Object)"r", (Object)option.getOptionSwitch());
        }
    }

    @Test
    public void testMissingArgument() throws IOException {
        try {
            String[] args = new String[]{"-n", "test", "-r"};
            this.parser.parseArguments(args);
            Assert.fail((String)"testMissingArgument failed");
        }
        catch (BadUsageException ex) {
            Object[] errors = ex.getErrors().toArray();
            Assert.assertEquals((String)"testInvalidOption failed", (long)1L, (long)errors.length);
            CommandLineError error = (CommandLineError)errors[0];
            Assert.assertTrue((String)"Expected MissingArgument error", (boolean)(error instanceof ErrorVisitor.MissingArgument));
            ErrorVisitor.MissingArgument arg = (ErrorVisitor.MissingArgument)error;
            Assert.assertEquals((String)"MissingArgument incorrect", (Object)"wsdlurl", (Object)arg.getArgument());
        }
    }

    @Test
    public void testDuplicateArgument() throws IOException {
        try {
            String[] args = new String[]{"-n", "test", "-r", "arg1", "arg2"};
            this.parser.parseArguments(args);
            Assert.fail((String)"testUnexpectedArgument failed");
        }
        catch (BadUsageException ex) {
            Object[] errors = ex.getErrors().toArray();
            Assert.assertEquals((String)"testInvalidOption failed", (long)1L, (long)errors.length);
            CommandLineError error = (CommandLineError)errors[0];
            Assert.assertTrue((String)"Expected UnexpectedArgument error", (boolean)(error instanceof ErrorVisitor.UnexpectedArgument));
        }
    }

    @Test
    public void testUnexpectedOption() throws IOException {
        try {
            String[] args = new String[]{"-n", "test", "-r", "-unknown"};
            this.parser.parseArguments(args);
            Assert.fail((String)"testUnexpectedOption failed");
        }
        catch (BadUsageException ex) {
            Object[] errors = ex.getErrors().toArray();
            Assert.assertEquals((String)"testInvalidOption failed", (long)1L, (long)errors.length);
            CommandLineError error = (CommandLineError)errors[0];
            Assert.assertTrue((String)"Expected UnexpectedOption error", (boolean)(error instanceof ErrorVisitor.UnexpectedOption));
            ErrorVisitor.UnexpectedOption option = (ErrorVisitor.UnexpectedOption)error;
            Assert.assertEquals((String)"UnexpectedOption incorrect", (Object)"-unknown", (Object)option.getOptionSwitch());
        }
    }

    @Test
    public void testInvalidPackageName() throws IOException {
        try {
            String[] args = new String[]{"-p", "/test", "arg1"};
            this.parser.parseArguments(args);
            Assert.fail((String)"testInvalidPackageName failed");
        }
        catch (BadUsageException ex) {
            Object[] errors = ex.getErrors().toArray();
            Assert.assertEquals((String)"testInvalidPackageName failed", (long)1L, (long)errors.length);
            CommandLineError error = (CommandLineError)errors[0];
            Assert.assertTrue((String)"Expected InvalidArgumentValue error", (boolean)(error instanceof ErrorVisitor.UserError));
            ErrorVisitor.UserError userError = (ErrorVisitor.UserError)error;
            Assert.assertEquals((String)"Invalid argument value message incorrect", (Object)"-p has invalid character!", (Object)userError.toString());
        }
    }

    @Test
    public void testvalidPackageName() throws Exception {
        String[] args = new String[]{"-p", "http://www.iona.com/hello_world_soap_http=com.iona", "-r", "arg1"};
        CommandDocument result = this.parser.parseArguments(args);
        Assert.assertEquals((String)"testValidPackageName Failed", (Object)"http://www.iona.com/hello_world_soap_http=com.iona", (Object)result.getParameter("packagename"));
    }

    @Test
    public void testUsage() throws Exception {
        String usage = "[ -n <C++ Namespace> ] [ -impl ] [ -e <Enum Value> ] -r [ -p <[wsdl namespace =]Package Name> ]* [ -? ] [ -v ] <wsdlurl> ";
        String pUsage = this.parser.getUsage();
        if (this.isQuolifiedVersion()) {
            Assert.assertEquals((String)"This test failed in the xerces version above 2.7.1 or the version with JDK ", (Object)usage, (Object)pUsage);
        } else {
            usage = "[ -n <C++ Namespace> ] [ -impl ] [ -e <Enum Value> ] -r -p <[wsdl namespace =]Package Name>* [ -? ] [ -v ] <wsdlurl>";
            Assert.assertEquals((String)"This test failed in the xerces version below 2.7.1", (Object)usage.trim(), (Object)pUsage.trim());
        }
    }

    private boolean isQuolifiedVersion() {
        try {
            Class<?> c = Class.forName("org.apache.xerces.impl.Version");
            Object o = c.newInstance();
            String v = (String)c.getMethod("getVersion", new Class[0]).invoke(o, new Object[0]);
            v = StringUtils.getFirstFound((String)v, (String)"(\\d+.\\d+)").trim();
            if (v.charAt(0) >= '3') {
                return true;
            }
            return Integer.parseInt(v = v.substring(2)) >= 7;
        }
        catch (Exception exception) {
            return true;
        }
    }

    @Test
    public void testDetailedUsage() throws Exception {
        String specialItem = "[ -p <[wsdl namespace =]Package Name> ]*";
        if (!this.isQuolifiedVersion()) {
            specialItem = "-p <[wsdl namespace =]Package Name>*";
        }
        String[] expected = new String[]{"[ -n <C++ Namespace> ]", "Namespace", "[ -impl ]", "impl - the impl that will be used by this tool to do whatever it is this tool does.", "[ -e <Enum Value> ]", "enum", "-r", "required", specialItem, "The java package name to use for the generated code.Also, optionally specify the wsdl namespace mapping to a particular java packagename.", "[ -? ]", "help", "[ -v ]", "version", "<wsdlurl>", "WSDL/SCHEMA URL"};
        int index = 0;
        String lineSeparator = System.getProperty("line.separator");
        StringTokenizer st1 = new StringTokenizer(this.parser.getDetailedUsage(), lineSeparator);
        while (st1.hasMoreTokens()) {
            Assert.assertEquals((String)("Failed at line " + index), (Object)expected[index++], (Object)st1.nextToken().toString().trim());
        }
    }

    @Test
    public void testOtherMethods() throws Exception {
        String tsSource = "/org/apache/cxf/tools/common/toolspec/parser/resources/testtool.xml";
        ToolSpec toolspec = new ToolSpec(this.getClass().getResourceAsStream(tsSource), false);
        CommandLineParser commandLineParser = new CommandLineParser(null);
        commandLineParser.setToolSpec(toolspec);
        CommandDocument commandDocument = commandLineParser.parseArguments("-r unknown");
        Assert.assertNotNull((Object)commandDocument);
    }

    @Test
    public void testGetDetailedUsage() {
        Assert.assertEquals((Object)"Namespace", (Object)this.parser.getDetailedUsage("namespace"));
    }

    @Test
    public void testFormattedDetailedUsage() throws Exception {
        String usage = this.parser.getFormattedDetailedUsage();
        Assert.assertNotNull((Object)usage);
        StringTokenizer st1 = new StringTokenizer(usage, System.getProperty("line.separator"));
        Assert.assertEquals((long)14L, (long)st1.countTokens());
        while (st1.hasMoreTokens()) {
            String s = st1.nextToken();
            if (s.indexOf("java package") != -1) {
                Assert.assertTrue(((s = s.trim()).charAt(s.length() - 1) != 'o' ? 1 : 0) != 0);
                continue;
            }
            if (s.indexOf("impl - the") == -1) continue;
            Assert.assertTrue((s.charAt(s.length() - 1) == 'o' ? 1 : 0) != 0);
        }
    }
}

