/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.toolspec;

import java.io.InputStream;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.DummyToolContainer;
import org.apache.cxf.tools.common.toolspec.ToolRunner;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractToolContainerTest {
    private DummyToolContainer dummyTool;

    @Before
    public void setUp() throws Exception {
        String tsSource = "/org/apache/cxf/tools/common/toolspec/parser/resources/testtool.xml";
        ToolSpec toolspec = new ToolSpec(this.getClass().getResourceAsStream(tsSource), false);
        this.dummyTool = new DummyToolContainer(toolspec);
    }

    @Test
    public void testQuietMode() {
        try {
            this.dummyTool.setArguments(new String[]{"-q"});
            this.dummyTool.parseCommandLine();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNotNull((String)"Fail to redirect err output:", (Object)this.dummyTool.getErrOutputStream());
        Assert.assertNotNull((String)"Fail to redirect output:", (Object)this.dummyTool.getOutOutputStream());
    }

    @Test
    public void testInit() {
        try {
            this.dummyTool.init();
        }
        catch (ToolException e) {
            Assert.assertEquals((Object)"Tool specification has to be set before initializing", (Object)e.getMessage());
            return;
        }
    }

    @Test
    public void testToolRunner() throws Exception {
        String tsSource = "/org/apache/cxf/tools/common/toolspec/parser/resources/testtool.xml";
        String[] args = new String[]{"-r", "wsdlurl=dfd"};
        ToolRunner.runTool(DummyToolContainer.class, (InputStream)this.getClass().getResourceAsStream(tsSource), (boolean)false, (String[])args);
    }
}

