/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hello_world_soap_http;

import jakarta.annotation.Resource;
import jakarta.jws.HandlerChain;
import jakarta.jws.Oneway;
import jakarta.jws.WebMethod;
import jakarta.jws.WebResult;
import jakarta.jws.WebService;
import jakarta.xml.ws.RequestWrapper;
import jakarta.xml.ws.ResponseWrapper;
import jakarta.xml.ws.WebServiceContext;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.hello_world_soap_http.AnnotatedGreeterImpl;
import org.apache.hello_world_soap_http.BadRecordLitFault;
import org.apache.hello_world_soap_http.NoSuchCodeLitFault;

@WebService(name="Greeter", serviceName="SOAPService", targetNamespace="http://apache.org/hello_world_soap_http")
@HandlerChain(name="TestHandlerChain", file="handlers.xml")
public class AnnotatedGreeterNoOverloadImpl {
    private static final Logger LOG = Logger.getLogger(AnnotatedGreeterImpl.class.getName());
    @Resource
    private int foo;
    private WebServiceContext context;
    private final Map<String, Integer> invocationCount = new HashMap<String, Integer>();

    public AnnotatedGreeterNoOverloadImpl() {
        this.invocationCount.put("sayHi", 0);
        this.invocationCount.put("greetMe", 0);
        this.invocationCount.put("overloadedSayHi", 0);
    }

    public int getInvocationCount(String method) {
        if (this.invocationCount.containsKey(method)) {
            return this.invocationCount.get(method);
        }
        System.out.println("No invocation count for method: " + method);
        return 0;
    }

    @WebMethod
    @WebResult(name="responseType", targetNamespace="http://apache.org/hello_world_soap_http/types")
    @RequestWrapper(className="org.apache.hello_world_soap_http.types.SayHi", localName="sayHi", targetNamespace="http://apache.org/hello_world_soap_http/types")
    @ResponseWrapper(className="org.apache.hello_world_soap_http.types.SayHiResponse", localName="sayHiResponse", targetNamespace="http://apache.org/hello_world_soap_http/types")
    public String sayHi() {
        this.incrementInvocationCount("sayHi");
        return "Hi";
    }

    @WebMethod
    @WebResult(name="responseType", targetNamespace="http://apache.org/hello_world_soap_http/types")
    @RequestWrapper(className="org.apache.hello_world_soap_http.types.GreetMe", localName="greetMe", targetNamespace="http://apache.org/hello_world_soap_http/types")
    @ResponseWrapper(className="org.apache.hello_world_soap_http.types.GreetMeResponse", localName="greetMeResponse", targetNamespace="http://apache.org/hello_world_soap_http/types")
    public String greetMe(String me) {
        this.incrementInvocationCount("greetMe");
        return "Bonjour " + me + "!";
    }

    @WebMethod
    @RequestWrapper(className="org.apache.hello_world_soap_http.types.GreetMeOneWay", localName="greetMeOneWay", targetNamespace="http://apache.org/hello_world_soap_http/types")
    @Oneway
    public void greetMeOneWay(String me) {
        this.incrementInvocationCount("greetMeOneWay");
        System.out.println("Hello there " + me);
        System.out.println("That was OneWay to say hello");
    }

    public void testDocLitFault(String faultType) throws BadRecordLitFault, NoSuchCodeLitFault {
    }

    @Resource
    public void setContext(WebServiceContext ctx) {
        this.context = ctx;
    }

    public WebServiceContext getContext() {
        return this.context;
    }

    public int getFoo() {
        return this.foo;
    }

    private void incrementInvocationCount(String method) {
        LOG.info("Executing " + method);
        int n = this.invocationCount.get(method);
        this.invocationCount.put(method, n + 1);
    }
}

