/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.customer.wraped;

import java.util.HashMap;
import java.util.Map;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import org.apache.cxf.customer.Customer;
import org.apache.cxf.customer.Customers;

@WebService(targetNamespace="http://cxf.apache.org/jra")
public class CustomerService {
    long currentId = 1L;
    Map<Long, Customer> customers = new HashMap<Long, Customer>();

    public CustomerService() {
        Customer customer = this.createCustomer();
        this.customers.put(customer.getId(), customer);
    }

    @WebMethod
    @WebResult(name="customers")
    public Customers getCustomers() {
        Customers cbean = new Customers();
        cbean.setCustomer(this.customers.values());
        return cbean;
    }

    @WebMethod
    @WebResult(name="customer")
    public Customer getCustomer(@WebParam(name="id") Long id) {
        return this.customers.get(id);
    }

    @WebMethod
    public void updateCustomer(@WebParam(name="id") String id, @WebParam(name="customer") Customer c) {
        this.customers.put(c.getId(), c);
    }

    @WebMethod
    public void addCustomer(@WebParam(name="customer") Customer c) {
        long id = ++this.currentId;
        c.setId(id);
        this.customers.put(id, c);
    }

    @WebMethod
    public void deleteCustomer(String id) {
        this.customers.remove(Long.valueOf(id));
    }

    final Customer createCustomer() {
        Customer c = new Customer();
        c.setName("Dan Diephouse");
        c.setId(123L);
        return c;
    }
}

