/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.testutil.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.testutil.common.AbstractTestServerBase;
import org.apache.cxf.testutil.common.TestUtil;

public class ServerLauncher {
    public static final long DEFAULT_TIMEOUT = TimeUnit.MINUTES.toMillis(1L);
    protected static final String SERVER_FAILED = "server startup failed (not a log message)";
    private static final boolean DEFAULT_IN_PROCESS = false;
    private static final Logger LOG = LogUtils.getLogger(ServerLauncher.class);
    private static final boolean DEBUG = false;
    private static final String JAVA_EXE = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
    boolean serverPassed;
    final String className;
    private boolean inProcess = false;
    private AbstractTestServerBase inProcessServer;
    private Process process;
    private boolean serverIsReady;
    private boolean serverIsStopped;
    private boolean serverLaunchFailed;
    private Map<String, String> properties;
    private String[] serverArgs;
    private final Mutex mutex = new Mutex();

    public ServerLauncher(String theClassName) {
        this(theClassName, false);
    }

    public ServerLauncher(AbstractTestServerBase b) {
        this.inProcess = true;
        this.inProcessServer = b;
        this.className = null;
    }

    public ServerLauncher(String theClassName, boolean inprocess) {
        this.inProcess = inprocess;
        this.className = theClassName;
    }

    public ServerLauncher(String theClassName, Map<String, String> p, String[] args) {
        this(theClassName, p, args, false);
    }

    public ServerLauncher(String theClassName, Map<String, String> p, String[] args, boolean inprocess) {
        this.className = theClassName;
        this.properties = p;
        this.serverArgs = args;
        this.inProcess = inprocess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForServerToStop() {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            TimeoutCounter tc = new TimeoutCounter(DEFAULT_TIMEOUT);
            while (!this.serverIsStopped) {
                try {
                    this.mutex.wait(1000L);
                    if (!tc.isTimeoutExpired()) continue;
                    System.out.println("destroying server process");
                    this.process.destroy();
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
            if (!this.inProcess) {
                tc = new TimeoutCounter(DEFAULT_TIMEOUT);
                while (!tc.isTimeoutExpired()) {
                    try {
                        this.process.exitValue();
                        break;
                    }
                    catch (IllegalThreadStateException ex) {
                        try {
                            this.mutex.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (tc.isTimeoutExpired()) {
                    this.process.destroy();
                }
            }
        }
        return this.serverIsStopped;
    }

    public void signalStop() throws IOException {
        if (this.process != null) {
            this.process.getOutputStream().write(113);
            this.process.getOutputStream().write(10);
            this.process.getOutputStream().flush();
        }
    }

    public boolean stopServer() throws IOException {
        if (this.inProcess) {
            try {
                return this.inProcessServer.stopInProcess();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IOException(ex.getMessage());
            }
        }
        if (this.process != null) {
            if (!this.serverIsStopped) {
                try {
                    this.signalStop();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.waitForServerToStop();
            this.process.destroy();
        }
        return this.serverPassed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean launchServer() throws IOException {
        block22: {
            block23: {
                this.serverIsReady = false;
                this.serverLaunchFailed = false;
                if (!this.inProcess) break block23;
                HashMap<String, String> old = new HashMap<String, String>();
                try {
                    if (null != this.properties) {
                        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                            old.put(entry.getKey(), System.getProperty(entry.getKey()));
                            if (entry.getValue() == null) {
                                System.clearProperty(entry.getKey());
                                continue;
                            }
                            System.setProperty(entry.getKey(), entry.getValue());
                        }
                    }
                    if (this.inProcessServer == null) {
                        Class<?> cls = Class.forName(this.className);
                        Class<AbstractTestServerBase> svcls = cls.asSubclass(AbstractTestServerBase.class);
                        if (null == this.serverArgs) {
                            this.inProcessServer = (AbstractTestServerBase)svcls.newInstance();
                        } else {
                            Constructor constructor = svcls.getConstructor(this.serverArgs.getClass());
                            this.inProcessServer = (AbstractTestServerBase)constructor.newInstance(new Object[]{this.serverArgs});
                        }
                    }
                    this.inProcessServer.startInProcess();
                    this.serverIsReady = true;
                }
                catch (Throwable ex) {
                    try {
                        ex.printStackTrace();
                        this.serverLaunchFailed = true;
                        return this.serverLaunchFailed;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        for (Map.Entry entry : old.entrySet()) {
                            if (entry.getValue() == null) {
                                System.clearProperty((String)entry.getKey());
                                continue;
                            }
                            System.setProperty((String)entry.getKey(), (String)entry.getValue());
                        }
                        break block22;
                    }
                }
                for (Map.Entry entry : old.entrySet()) {
                    if (entry.getValue() == null) {
                        System.clearProperty((String)entry.getKey());
                        continue;
                    }
                    System.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
                break block22;
            }
            Map.Entry<Map<String, String>, List<String>> commandAndEnvironment = this.getCommandAndEnvironment();
            List<String> cmd = commandAndEnvironment.getValue();
            LOG.fine("CMD: " + cmd);
            ProcessBuilder pb = new ProcessBuilder(cmd);
            pb.environment().putAll(commandAndEnvironment.getKey());
            pb.redirectErrorStream(true);
            this.process = pb.start();
            OutputMonitorThread outputMonitorThread = new OutputMonitorThread(this.process.getInputStream());
            outputMonitorThread.start();
            Mutex mutex = this.mutex;
            synchronized (mutex) {
                TimeoutCounter tc = new TimeoutCounter(DEFAULT_TIMEOUT);
                while (!this.serverIsReady && !this.serverLaunchFailed) {
                    try {
                        this.mutex.wait(1000L);
                        if (!tc.isTimeoutExpired()) continue;
                        break;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.serverLaunchFailed || !this.serverIsReady) {
                System.err.println(outputMonitorThread.getServerOutput());
            }
        }
        return this.serverIsReady && !this.serverLaunchFailed;
    }

    public int waitForServer() {
        int ret = -1;
        try {
            this.process.waitFor();
            ret = this.process.exitValue();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyServerIsReady() {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            this.serverIsReady = true;
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyServerIsStopped() {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            LOG.info("notify server stopped");
            this.serverIsStopped = true;
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyServerFailed() {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            this.serverIsStopped = true;
            this.serverLaunchFailed = true;
            this.mutex.notifyAll();
        }
    }

    private Map.Entry<Map<String, String>, List<String>> getCommandAndEnvironment() {
        String tmp;
        String derbyHome;
        String validationMode;
        boolean isWindows;
        StringBuilder classpath;
        String loggingPropertiesFile;
        String simpleName;
        int idx;
        HashMap<String, String> env = new HashMap<String, String>();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(JAVA_EXE);
        if (null != this.properties) {
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                cmd.add("-D" + entry.getKey() + "=" + entry.getValue());
            }
        }
        if (-1 != (idx = (simpleName = this.className.substring(this.className.lastIndexOf(46) + 1)).indexOf(36))) {
            simpleName = simpleName.substring(0, idx);
        }
        for (Map.Entry<Object, Object> entry : TestUtil.getAllPorts().entrySet()) {
            String key = entry.getKey().toString();
            if (!key.contains(simpleName)) continue;
            cmd.add("-D" + key + "=" + entry.getValue());
        }
        String vmargs = System.getProperty("server.launcher.vmargs");
        if (StringUtils.isEmpty((String)vmargs)) {
            cmd.add("-ea");
        } else {
            vmargs = vmargs.trim();
            idx = vmargs.indexOf(32);
            while (idx != -1) {
                cmd.add(vmargs.substring(0, idx));
                vmargs = vmargs.substring(idx + 1);
                idx = vmargs.indexOf(32);
            }
            cmd.add(vmargs);
        }
        String portClose = System.getProperty("org.apache.cxf.transports.http_jetty.DontClosePort");
        if (portClose != null) {
            cmd.add("-Dorg.apache.cxf.transports.http_jetty.DontClosePort=" + portClose);
        }
        if (null != (loggingPropertiesFile = System.getProperty("java.util.logging.config.file"))) {
            cmd.add("-Djava.util.logging.config.file=" + loggingPropertiesFile);
        }
        if ((classpath = new StringBuilder(System.getProperty("java.class.path"))).indexOf("/.compatibility/") != -1) {
            classpath.append(':');
            idx = classpath.indexOf("/.compatibility/");
            int idx1 = classpath.lastIndexOf(":", idx);
            int idx2 = classpath.indexOf(":", idx);
            classpath.replace(idx1, idx2, ":");
        }
        if (!(isWindows = System.getProperty("os.name").startsWith("Windows"))) {
            cmd.add("-classpath");
            cmd.add(classpath.toString());
        } else {
            env.putIfAbsent("CLASSPATH", classpath.toString());
        }
        String transformerProperty = System.getProperty("javax.xml.transform.TransformerFactory");
        if (null != transformerProperty) {
            cmd.add("-Djavax.xml.transform.TransformerFactory=" + transformerProperty);
        }
        if (null != (validationMode = System.getProperty("spring.validation.mode"))) {
            cmd.add("-Dspring.validation.mode=" + validationMode);
        }
        if (null != (derbyHome = System.getProperty("derby.system.home"))) {
            cmd.add("-Dderby.system.home=" + derbyHome);
        }
        if (null != (tmp = System.getProperty("java.io.tmpdir"))) {
            cmd.add("-Djava.io.tmpdir=" + tmp);
        }
        cmd.add(this.className);
        if (null != this.serverArgs) {
            for (String s : this.serverArgs) {
                cmd.add(s);
            }
        }
        return new AbstractMap.SimpleEntry<Map<String, String>, List<String>>(env, cmd);
    }

    static class TimeoutCounter {
        private final long expectedEndTime;

        TimeoutCounter(long theExpectedTimeout) {
            this.expectedEndTime = System.currentTimeMillis() + theExpectedTimeout;
        }

        public boolean isTimeoutExpired() {
            return System.currentTimeMillis() > this.expectedEndTime;
        }
    }

    static class Mutex {
        Mutex() {
        }
    }

    private class OutputMonitorThread
    extends Thread {
        InputStream in;
        StringBuilder serverOutputAll = new StringBuilder();

        OutputMonitorThread(InputStream i) {
            this.in = i;
        }

        public String getServerOutput() {
            return this.serverOutputAll.toString();
        }

        @Override
        public void run() {
            block27: {
                OutputStream os;
                block26: {
                    String outputDir = System.getProperty("server.output.dir", "target/surefire-reports/");
                    os = null;
                    try {
                        Path logFile = Paths.get(outputDir + ServerLauncher.this.className + ".out", new String[0]);
                        Files.createDirectories(logFile.getParent(), new FileAttribute[0]);
                        os = Files.newOutputStream(logFile, new OpenOption[0]);
                    }
                    catch (IOException ex) {
                        if (ex.getMessage().contains("Stream closed")) break block26;
                        ex.printStackTrace();
                    }
                }
                try (PrintStream ps = new PrintStream(os);){
                    StringBuilder serverOutput = new StringBuilder();
                    int ch = this.in.read();
                    while (ch != -1) {
                        serverOutput.append((char)ch);
                        if (ch == 10) {
                            String line = serverOutput.toString();
                            serverOutput.setLength(0);
                            this.serverOutputAll.append(line);
                            if (line.contains("server ready")) {
                                ServerLauncher.this.notifyServerIsReady();
                            } else if (line.contains("server passed")) {
                                ServerLauncher.this.serverPassed = true;
                            } else if (line.contains("server stopped")) {
                                ServerLauncher.this.notifyServerIsStopped();
                            } else if (line.contains(ServerLauncher.SERVER_FAILED)) {
                                ServerLauncher.this.notifyServerFailed();
                            }
                            ps.print(line);
                            if (this.serverOutputAll.length() > 64000) {
                                this.serverOutputAll.delete(0, 10000);
                            }
                        }
                        ch = this.in.read();
                    }
                }
                catch (IOException ex) {
                    if (ex.getMessage().contains("Stream closed")) break block27;
                    ex.printStackTrace();
                }
            }
        }
    }
}

