/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.test;

import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.test.AbstractCXFTest;
import org.junit.After;
import org.junit.Before;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public abstract class AbstractCXFSpringTest
extends AbstractCXFTest {
    protected static GenericApplicationContext applicationContext;
    private DefaultResourceLoader resourceLoader;
    private Class<?> configContextClass = AbstractCXFSpringTest.class;

    protected AbstractCXFSpringTest() {
    }

    @Before
    public void setupBeans() throws Exception {
        if (applicationContext != null) {
            return;
        }
        applicationContext = new GenericApplicationContext();
        this.resourceLoader = new DefaultResourceLoader(this.configContextClass.getClassLoader());
        for (String beanDefinitionPath : this.getConfigLocations()) {
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)applicationContext);
            Resource resource = this.resourceLoader.getResource(beanDefinitionPath);
            reader.loadBeanDefinitions(resource);
        }
        this.additionalSpringConfiguration(applicationContext);
        applicationContext.refresh();
        super.setUpBus();
    }

    @Override
    @Before
    public void setUpBus() throws Exception {
    }

    @Override
    public Bus createBus() throws BusException {
        return this.getBean(Bus.class, "cxf");
    }

    @After
    public void teardownBeans() {
        applicationContext.close();
        applicationContext = null;
    }

    protected abstract String[] getConfigLocations();

    protected ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    protected void additionalSpringConfiguration(GenericApplicationContext context) throws Exception {
    }

    protected <T> T getBean(Class<T> type, String beanName) {
        return type.cast(applicationContext.getBean(beanName));
    }

    protected void setConfigContextClass(Class<?> configContextClass) {
        this.configContextClass = configContextClass;
    }
}

