/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractTokenPolicyValidator;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSDerivedKeyTokenPrincipal;
import org.apache.ws.security.WSSecurityEngineResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgorithmSuitePolicyValidator
extends AbstractTokenPolicyValidator {
    private List<WSSecurityEngineResult> results;

    public AlgorithmSuitePolicyValidator(List<WSSecurityEngineResult> results) {
        this.results = results;
    }

    public boolean validatePolicy(AssertionInfo aiBinding, AlgorithmSuite algorithmPolicy) {
        for (WSSecurityEngineResult result : this.results) {
            Integer actInt = (Integer)result.get((Object)"action");
            if (2 == actInt && !this.checkSignatureAlgorithms(result, algorithmPolicy, aiBinding)) {
                return false;
            }
            if (4 != actInt || this.checkEncryptionAlgorithms(result, algorithmPolicy, aiBinding)) continue;
            return false;
        }
        return true;
    }

    private boolean checkSignatureAlgorithms(WSSecurityEngineResult result, AlgorithmSuite algorithmPolicy, AssertionInfo ai) {
        String signatureMethod = (String)result.get((Object)"signature-method");
        if (!algorithmPolicy.getAsymmetricSignature().equals(signatureMethod) && !algorithmPolicy.getSymmetricSignature().equals(signatureMethod)) {
            ai.setNotAsserted("The signature method does not match the requirement");
            return false;
        }
        String c14nMethod = (String)result.get((Object)"canonicalization-method");
        if (!algorithmPolicy.getInclusiveC14n().equals(c14nMethod)) {
            ai.setNotAsserted("The c14n method does not match the requirement");
            return false;
        }
        List dataRefs = CastUtils.cast((List)((List)result.get((Object)"data-ref-uris")));
        for (WSDataRef dataRef : dataRefs) {
            String digestMethod = dataRef.getDigestAlgorithm();
            if (algorithmPolicy.getDigest().equals(digestMethod)) continue;
            ai.setNotAsserted("The digest method does not match the requirement");
            return false;
        }
        return this.checkKeyLengths(result, algorithmPolicy, ai, true);
    }

    private boolean checkEncryptionAlgorithms(WSSecurityEngineResult result, AlgorithmSuite algorithmPolicy, AssertionInfo ai) {
        String transportMethod = (String)result.get((Object)"encrypted-key-transport-method");
        if (transportMethod != null && !algorithmPolicy.getSymmetricKeyWrap().equals(transportMethod) && !algorithmPolicy.getAsymmetricKeyWrap().equals(transportMethod)) {
            ai.setNotAsserted("The Key transport method does not match the requirement");
            return false;
        }
        List dataRefs = CastUtils.cast((List)((List)result.get((Object)"data-ref-uris")));
        if (dataRefs != null) {
            for (WSDataRef dataRef : dataRefs) {
                String encryptionAlgorithm = dataRef.getAlgorithm();
                if (algorithmPolicy.getEncryption().equals(encryptionAlgorithm)) continue;
                ai.setNotAsserted("The encryption algorithm does not match the requirement");
                return false;
            }
        }
        return this.checkKeyLengths(result, algorithmPolicy, ai, false);
    }

    private boolean checkKeyLengths(WSSecurityEngineResult result, AlgorithmSuite algorithmPolicy, AssertionInfo ai, boolean signature) {
        PublicKey publicKey = (PublicKey)result.get((Object)"public-key");
        if (publicKey != null && !this.checkPublicKeyLength(publicKey, algorithmPolicy, ai)) {
            return false;
        }
        X509Certificate x509Cert = (X509Certificate)result.get((Object)"x509-certificate");
        if (x509Cert != null && !this.checkPublicKeyLength(x509Cert.getPublicKey(), algorithmPolicy, ai)) {
            return false;
        }
        byte[] secret = (byte[])result.get((Object)"secret");
        if (signature) {
            Principal principal = (Principal)result.get((Object)"principal");
            if (principal instanceof WSDerivedKeyTokenPrincipal) {
                int requiredLength = algorithmPolicy.getSignatureDerivedKeyLength();
                if (secret == null || secret.length != requiredLength / 8) {
                    ai.setNotAsserted("The signature derived key length does not match the requirement");
                    return false;
                }
            } else if (secret != null && (secret.length < algorithmPolicy.getMinimumSymmetricKeyLength() / 8 || secret.length > algorithmPolicy.getMaximumSymmetricKeyLength() / 8)) {
                ai.setNotAsserted("The symmetric key length does not match the requirement");
                return false;
            }
        } else if (secret != null && (secret.length < algorithmPolicy.getMinimumSymmetricKeyLength() / 8 || secret.length > algorithmPolicy.getMaximumSymmetricKeyLength() / 8)) {
            ai.setNotAsserted("The symmetric key length does not match the requirement");
            return false;
        }
        return true;
    }

    private boolean checkPublicKeyLength(PublicKey publicKey, AlgorithmSuite algorithmPolicy, AssertionInfo ai) {
        if (publicKey instanceof RSAPublicKey) {
            int modulus = ((RSAPublicKey)publicKey).getModulus().bitLength();
            if (modulus < algorithmPolicy.getMinimumAsymmetricKeyLength() || modulus > algorithmPolicy.getMaximumAsymmetricKeyLength()) {
                ai.setNotAsserted("The asymmetric key length does not match the requirement");
                return false;
            }
        } else if (publicKey instanceof DSAPublicKey) {
            int length = ((DSAPublicKey)publicKey).getParams().getP().bitLength();
            if (length < algorithmPolicy.getMinimumAsymmetricKeyLength() || length > algorithmPolicy.getMaximumAsymmetricKeyLength()) {
                ai.setNotAsserted("The asymmetric key length does not match the requirement");
                return false;
            }
        } else {
            ai.setNotAsserted("An unknown public key was provided");
            return false;
        }
        return true;
    }
}

