/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket.undertow;

import io.undertow.server.HttpServerExchange;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.WebSocketChannel;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ReadListener;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.transport.websocket.WebSocketUtils;
import org.apache.cxf.transport.websocket.undertow.ByteBufferInputStream;

public class WebSocketUndertowServletRequest
implements HttpServletRequest {
    private static final Logger LOG = LogUtils.getL7dLogger(WebSocketUndertowServletRequest.class);
    private WebSocketChannel channel;
    private Map<String, String> requestHeaders;
    private Map<String, Object> attributes;
    private InputStream in;

    public WebSocketUndertowServletRequest(WebSocketChannel channel, Object message, HttpServerExchange exchange) throws IOException {
        this.channel = channel;
        if (message instanceof BufferedBinaryMessage) {
            this.in = new ByteBufferInputStream(((ByteBuffer[])((BufferedBinaryMessage)message).getData().getResource())[0]);
        } else if (message instanceof BufferedTextMessage) {
            this.in = new ByteArrayInputStream(((BufferedTextMessage)message).getData().getBytes());
        }
        this.requestHeaders = WebSocketUtils.readHeaders(this.in);
        this.attributes = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        Object v = channel.getAttribute("org.apache.cxf.transport.endpoint.address");
        if (v != null) {
            this.attributes.put("org.apache.cxf.transport.endpoint.address", v);
        }
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public Object getAttribute(String name) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "getAttribute({0}) -> {1}", new Object[]{name, this.attributes.get(name)});
        }
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        LOG.log(Level.FINE, "getAttributeNames()");
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        LOG.log(Level.FINE, "getCharacterEncoding()");
        return null;
    }

    public int getContentLength() {
        LOG.log(Level.FINE, "getContentLength()");
        return 0;
    }

    public String getContentType() {
        LOG.log(Level.FINE, "getContentType()");
        return this.requestHeaders.get("Content-Type");
    }

    public DispatcherType getDispatcherType() {
        LOG.log(Level.FINE, "getDispatcherType()");
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStream(){

            public int read() throws IOException {
                return WebSocketUndertowServletRequest.this.in.read();
            }

            public int read(byte[] b, int off, int len) throws IOException {
                return WebSocketUndertowServletRequest.this.in.read(b, off, len);
            }

            public boolean isFinished() {
                throw new UnsupportedOperationException();
            }

            public boolean isReady() {
                throw new UnsupportedOperationException();
            }

            public void setReadListener(ReadListener arg0) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String getLocalAddr() {
        LOG.log(Level.FINE, "getLocalAddr()");
        try {
            return new URL(this.channel.getUrl()).getHost();
        }
        catch (MalformedURLException e) {
            LOG.log(Level.FINE, "getLocalAddr error", e);
            return null;
        }
    }

    public String getLocalName() {
        LOG.log(Level.FINE, "getLocalName()");
        try {
            return new URL(this.channel.getUrl()).getHost();
        }
        catch (MalformedURLException e) {
            LOG.log(Level.FINE, "getLocalName error", e);
            return null;
        }
    }

    public int getLocalPort() {
        LOG.log(Level.FINE, "getLocalPort()");
        try {
            return new URL(this.channel.getUrl()).getPort();
        }
        catch (MalformedURLException e) {
            LOG.log(Level.FINE, "getLocalPort error", e);
            return 0;
        }
    }

    public Locale getLocale() {
        LOG.log(Level.FINE, "getLocale()");
        return null;
    }

    public Enumeration<Locale> getLocales() {
        LOG.log(Level.FINE, "getLocales()");
        return null;
    }

    public String getParameter(String name) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "getParameter({0})", name);
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        LOG.log(Level.FINE, "getParameterMap()");
        return null;
    }

    public Enumeration<String> getParameterNames() {
        LOG.log(Level.FINE, "getParameterNames()");
        return null;
    }

    public String[] getParameterValues(String name) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "getParameterValues({0})", name);
        }
        return null;
    }

    public String getProtocol() {
        LOG.log(Level.FINE, "getProtocol");
        try {
            return new URL(this.channel.getUrl()).getProtocol();
        }
        catch (MalformedURLException e) {
            LOG.log(Level.FINE, "getProtocol error", e);
            return null;
        }
    }

    public BufferedReader getReader() throws IOException {
        LOG.log(Level.FINE, "getReader");
        return new BufferedReader(new InputStreamReader(this.in, StandardCharsets.UTF_8));
    }

    public String getRealPath(String path) {
        LOG.log(Level.FINE, "getRealPath");
        return null;
    }

    public String getRemoteAddr() {
        LOG.log(Level.FINE, "getRemoteAddr");
        try {
            return new URL(this.channel.getPeerAddress().toString()).getHost();
        }
        catch (MalformedURLException e) {
            LOG.log(Level.FINE, "getRemoteAddr error", e);
            return null;
        }
    }

    public String getRemoteHost() {
        LOG.log(Level.FINE, "getRemoteHost");
        try {
            return new URL(this.channel.getPeerAddress().toString()).getHost();
        }
        catch (MalformedURLException e) {
            LOG.log(Level.FINE, "getRemoteHost error", e);
            return null;
        }
    }

    public int getRemotePort() {
        LOG.log(Level.FINE, "getRemotePort");
        try {
            return new URL(this.channel.getPeerAddress().toString()).getPort();
        }
        catch (MalformedURLException e) {
            LOG.log(Level.FINE, "getRemotePort error", e);
            return 0;
        }
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        LOG.log(Level.FINE, "getRequestDispatcher");
        return null;
    }

    public String getScheme() {
        LOG.log(Level.FINE, "getScheme");
        try {
            return new URL(this.channel.getUrl()).getProtocol();
        }
        catch (MalformedURLException e) {
            LOG.log(Level.FINE, "getScheme error", e);
            return null;
        }
    }

    public String getServerName() {
        return this.getLocalName();
    }

    public int getServerPort() {
        LOG.log(Level.FINE, "getServerPort");
        return this.getLocalPort();
    }

    public ServletContext getServletContext() {
        LOG.log(Level.FINE, "getServletContext");
        return null;
    }

    public boolean isAsyncStarted() {
        LOG.log(Level.FINE, "isAsyncStarted");
        return false;
    }

    public boolean isAsyncSupported() {
        LOG.log(Level.FINE, "isAsyncSupported");
        return false;
    }

    public boolean isSecure() {
        LOG.log(Level.FINE, "isSecure");
        return false;
    }

    public void removeAttribute(String name) {
        LOG.log(Level.FINE, "removeAttribute");
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object o) {
        LOG.log(Level.FINE, "setAttribute");
        this.attributes.put(name, o);
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        LOG.log(Level.FINE, "setCharacterEncoding");
    }

    public AsyncContext startAsync() {
        LOG.log(Level.FINE, "startAsync");
        return null;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
        LOG.log(Level.FINE, "startAsync");
        return null;
    }

    public boolean authenticate(HttpServletResponse servletResponse) throws IOException, ServletException {
        LOG.log(Level.FINE, "authenticate");
        return false;
    }

    public String getAuthType() {
        LOG.log(Level.FINE, "getAuthType");
        return "null";
    }

    public String getContextPath() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "getContextPath -> " + null);
        }
        return null;
    }

    public Cookie[] getCookies() {
        LOG.log(Level.FINE, "getCookies");
        return null;
    }

    public long getDateHeader(String name) {
        LOG.log(Level.FINE, "getDateHeader");
        return 0L;
    }

    public String getHeader(String name) {
        LOG.log(Level.FINE, "getHeader");
        return this.requestHeaders.get(name);
    }

    public Enumeration<String> getHeaderNames() {
        LOG.log(Level.FINE, "getHeaderNames");
        return Collections.enumeration(this.requestHeaders.keySet());
    }

    public Enumeration<String> getHeaders(String name) {
        LOG.log(Level.FINE, "getHeaders");
        if (this.requestHeaders.get(name) != null) {
            return Collections.enumeration(Arrays.asList(this.requestHeaders.get(name)));
        }
        return Collections.enumeration(Arrays.asList(new String[0]));
    }

    public int getIntHeader(String name) {
        LOG.log(Level.FINE, "getIntHeader");
        String v = this.requestHeaders.get(name);
        return v == null ? -1 : Integer.parseInt(v);
    }

    public String getMethod() {
        LOG.log(Level.FINE, "getMethod");
        return this.requestHeaders.get("$method");
    }

    public Part getPart(String name) throws IOException, ServletException {
        LOG.log(Level.FINE, "getPart");
        return null;
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        LOG.log(Level.FINE, "getParts");
        return null;
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getQueryString() {
        LOG.log(Level.FINE, "getQueryString");
        return null;
    }

    public String getRemoteUser() {
        LOG.log(Level.FINE, "getRemoteUser");
        return null;
    }

    public String getRequestURI() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "getRequestURI " + this.requestHeaders.get("$uri"));
        }
        return this.requestHeaders.get("$uri");
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.getRequestURI());
    }

    public String getRequestedSessionId() {
        LOG.log(Level.FINE, "getRequestedSessionId");
        return null;
    }

    public String getServletPath() {
        return null;
    }

    public HttpSession getSession() {
        LOG.log(Level.FINE, "getSession");
        return null;
    }

    public HttpSession getSession(boolean create) {
        LOG.log(Level.FINE, "getSession");
        return null;
    }

    public Principal getUserPrincipal() {
        LOG.log(Level.FINE, "getUserPrincipal");
        return null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        LOG.log(Level.FINE, "isRequestedSessionIdFromCookie");
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        LOG.log(Level.FINE, "isRequestedSessionIdFromURL");
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        LOG.log(Level.FINE, "isRequestedSessionIdFromUrl");
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        LOG.log(Level.FINE, "isRequestedSessionIdValid");
        return false;
    }

    public boolean isUserInRole(String role) {
        LOG.log(Level.FINE, "isUserInRole");
        return false;
    }

    public void login(String username, String password) throws ServletException {
        LOG.log(Level.FINE, "login");
    }

    public void logout() throws ServletException {
        LOG.log(Level.FINE, "logout");
    }

    public long getContentLengthLong() {
        throw new UnsupportedOperationException();
    }

    public String changeSessionId() {
        throw new UnsupportedOperationException();
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> arg0) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }
}

