/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.udp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.LoadingByteArrayOutputStream;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.udp.IoSessionInputStream;
import org.apache.cxf.transport.udp.IoSessionOutputStream;
import org.apache.cxf.workqueue.AutomaticWorkQueue;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.handler.stream.StreamIoHandler;
import org.apache.mina.transport.socket.DatagramSessionConfig;
import org.apache.mina.transport.socket.nio.NioDatagramAcceptor;

public class UDPDestination
extends AbstractDestination {
    public static final String NETWORK_INTERFACE = UDPDestination.class.getName() + ".NETWORK_INTERFACE";
    private static final Logger LOG = LogUtils.getL7dLogger(UDPDestination.class);
    private static final AttributeKey KEY_IN = new AttributeKey(StreamIoHandler.class, "in");
    private static final AttributeKey KEY_OUT = new AttributeKey(StreamIoHandler.class, "out");
    NioDatagramAcceptor acceptor;
    AutomaticWorkQueue queue;
    volatile MulticastSocket mcast;

    public UDPDestination(Bus b, EndpointReferenceType ref, EndpointInfo ei) {
        super(b, ref, ei);
    }

    protected Conduit getInbuiltBackChannel(final Message inMessage) {
        if (inMessage.getExchange().isOneWay()) {
            return null;
        }
        return new AbstractDestination.AbstractBackChannelConduit(){

            public void prepare(Message message) throws IOException {
                message.setContent(OutputStream.class, inMessage.get(OutputStream.class));
            }
        };
    }

    protected Logger getLogger() {
        return LOG;
    }

    protected void activate() {
        WorkQueueManager queuem = (WorkQueueManager)this.bus.getExtension(WorkQueueManager.class);
        this.queue = queuem.getNamedWorkQueue("udp-transport");
        if (this.queue == null) {
            this.queue = queuem.getAutomaticWorkQueue();
        }
        try {
            URI uri = new URI(this.getAddress().getAddress().getValue());
            InetSocketAddress isa = null;
            if (StringUtils.isEmpty((String)uri.getHost())) {
                String s = uri.getSchemeSpecificPart();
                if (s.startsWith("//:")) {
                    s = s.substring(3);
                }
                if (s.indexOf(47) != -1) {
                    s = s.substring(0, s.indexOf(47));
                }
                int port = Integer.parseInt(s);
                isa = new InetSocketAddress(port);
            } else {
                isa = new InetSocketAddress(uri.getHost(), uri.getPort());
            }
            if (isa.getAddress().isMulticastAddress()) {
                MulticastSocket socket = new MulticastSocket(null);
                socket.setReuseAddress(true);
                socket.setReceiveBufferSize(65536);
                socket.setSendBufferSize(65536);
                socket.setTimeToLive(1);
                socket.setLoopbackMode(false);
                socket.bind(new InetSocketAddress(isa.getPort()));
                socket.setNetworkInterface(this.findNetworkInterface());
                socket.joinGroup(isa.getAddress());
                this.mcast = socket;
                this.queue.execute((Runnable)new MCastListener());
            } else {
                this.acceptor = new NioDatagramAcceptor();
                this.acceptor.setHandler((IoHandler)new UDPIOHandler());
                this.acceptor.setDefaultLocalAddress(isa);
                DatagramSessionConfig dcfg = this.acceptor.getSessionConfig();
                dcfg.setReadBufferSize(65536);
                dcfg.setSendBufferSize(65536);
                dcfg.setReuseAddress(true);
                this.acceptor.bind();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private NetworkInterface findNetworkInterface() throws SocketException {
        String name = (String)this.getEndpointInfo().getProperty(NETWORK_INTERFACE);
        NetworkInterface ret = null;
        if (!StringUtils.isEmpty((String)name)) {
            ret = NetworkInterface.getByName(name);
        }
        if (ret == null) {
            Enumeration<NetworkInterface> ifcs = NetworkInterface.getNetworkInterfaces();
            ArrayList<NetworkInterface> possibles = new ArrayList<NetworkInterface>();
            while (ifcs.hasMoreElements()) {
                NetworkInterface ni = ifcs.nextElement();
                if (!ni.supportsMulticast() || !ni.isUp()) continue;
                for (InterfaceAddress ia : ni.getInterfaceAddresses()) {
                    if (!(ia.getAddress() instanceof Inet4Address) || ia.getAddress().isLoopbackAddress() || ni.getDisplayName().startsWith("vnic")) continue;
                    possibles.add(ni);
                }
            }
            ret = possibles.isEmpty() ? null : (NetworkInterface)possibles.get(possibles.size() - 1);
        }
        return ret;
    }

    protected void deactivate() {
        if (this.acceptor != null) {
            this.acceptor.unbind();
            this.acceptor.dispose();
        }
        this.acceptor = null;
        if (this.mcast != null) {
            this.mcast.close();
            this.mcast = null;
        }
    }

    static class UDPDestinationOutputStream
    extends OutputStream {
        final OutputStream out;
        IoBuffer buffer = IoBuffer.allocate((int)65494);
        boolean closed;

        UDPDestinationOutputStream(OutputStream out) {
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            this.buffer.put(new byte[]{(byte)b}, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            while (len > this.buffer.remaining()) {
                int nlen = this.buffer.remaining();
                this.buffer.put(b, off, nlen);
                len -= nlen;
                off += nlen;
                this.send();
                this.buffer = IoBuffer.allocate((int)65494);
            }
            this.buffer.put(b, off, len);
        }

        private void send() throws IOException {
            this.buffer.flip();
            this.out.write(this.buffer.array(), 0, this.buffer.limit());
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.send();
            this.out.close();
        }
    }

    private static class StreamIoException
    extends RuntimeException {
        private static final long serialVersionUID = 3976736960742503222L;

        StreamIoException(IOException cause) {
            super(cause);
        }
    }

    class UDPIOHandler
    extends StreamIoHandler {
        UDPIOHandler() {
        }

        public void sessionOpened(final IoSession session) {
            session.getConfig().setWriteTimeout(this.getWriteTimeout());
            session.getConfig().setIdleTime(IdleStatus.READER_IDLE, this.getReadTimeout());
            IoSessionInputStream in = new IoSessionInputStream();
            IoSessionOutputStream out = new IoSessionOutputStream(session){

                @Override
                public void close() throws IOException {
                    try {
                        this.flush();
                    }
                    finally {
                        CloseFuture future = session.closeNow();
                        future.awaitUninterruptibly();
                    }
                }
            };
            session.setAttribute((Object)KEY_IN, (Object)in);
            session.setAttribute((Object)KEY_OUT, (Object)out);
            this.processStreamIo(session, in, out);
        }

        protected void processStreamIo(IoSession session, InputStream in, OutputStream out) {
            MessageImpl m = new MessageImpl();
            ExchangeImpl exchange = new ExchangeImpl();
            exchange.setDestination((Destination)UDPDestination.this);
            m.setDestination((Destination)UDPDestination.this);
            exchange.setInMessage((Message)m);
            m.setContent(InputStream.class, (Object)in);
            out = new UDPDestinationOutputStream(out);
            m.put(OutputStream.class, (Object)out);
            UDPDestination.this.queue.execute(() -> UDPDestination.this.getMessageObserver().onMessage((Message)m));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionClosed(IoSession session) throws Exception {
            InputStream in = (InputStream)session.getAttribute((Object)KEY_IN);
            try (OutputStream out = (OutputStream)session.getAttribute((Object)KEY_OUT);){
                in.close();
            }
        }

        public void messageReceived(IoSession session, Object buf) {
            IoSessionInputStream in = (IoSessionInputStream)session.getAttribute((Object)KEY_IN);
            in.setBuffer((IoBuffer)buf);
        }

        public void exceptionCaught(IoSession session, Throwable cause) {
            IoSessionInputStream in = (IoSessionInputStream)session.getAttribute((Object)KEY_IN);
            IOException e = null;
            if (cause instanceof StreamIoException) {
                e = (IOException)cause.getCause();
            } else if (cause instanceof IOException) {
                e = (IOException)cause;
            }
            if (e != null && in != null) {
                in.throwException(e);
            } else {
                session.closeOnFlush().awaitUninterruptibly();
            }
        }

        public void sessionIdle(IoSession session, IdleStatus status) {
            if (status == IdleStatus.READER_IDLE) {
                throw new StreamIoException(new SocketTimeoutException("Read timeout"));
            }
        }
    }

    class MCastListener
    implements Runnable {
        MCastListener() {
        }

        @Override
        public void run() {
            while (UDPDestination.this.mcast != null) {
                try {
                    byte[] bytes = new byte[65536];
                    final DatagramPacket p = new DatagramPacket(bytes, bytes.length);
                    UDPDestination.this.mcast.receive(p);
                    LoadingByteArrayOutputStream out = new LoadingByteArrayOutputStream(){

                        public void close() throws IOException {
                            super.close();
                            DatagramPacket p2 = new DatagramPacket(this.getRawBytes(), 0, this.size(), p.getSocketAddress());
                            UDPDestination.this.mcast.send(p2);
                        }
                    };
                    MessageImpl m = new MessageImpl();
                    ExchangeImpl exchange = new ExchangeImpl();
                    exchange.setDestination((Destination)UDPDestination.this);
                    m.setDestination((Destination)UDPDestination.this);
                    exchange.setInMessage((Message)m);
                    m.setContent(InputStream.class, (Object)new ByteArrayInputStream(bytes, 0, p.getLength()));
                    m.put(OutputStream.class, (Object)out);
                    UDPDestination.this.queue.execute(() -> UDPDestination.this.getMessageObserver().onMessage((Message)m));
                    continue;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
            return;
        }
    }
}

