/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.util;

import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;

public class JMSMessageConverter {
    public Message toMessage(Object object, Session session) throws JMSException {
        if (object instanceof Message) {
            return (Message)object;
        }
        if (object instanceof String) {
            return session.createTextMessage((String)object);
        }
        if (object instanceof byte[]) {
            BytesMessage message = session.createBytesMessage();
            message.writeBytes((byte[])object);
            return message;
        }
        if (object instanceof Serializable) {
            return session.createObjectMessage((Serializable)object);
        }
        throw new IllegalArgumentException("Unsupported type " + this.nullSafeClassName(object) + ". Valid types are: String, byte[], Serializable object.");
    }

    private String nullSafeClassName(Object object) {
        return object == null ? "null" : object.getClass().getName();
    }

    public Object fromMessage(Message message) throws JMSException {
        if (message instanceof TextMessage) {
            return ((TextMessage)message).getText();
        }
        if (message instanceof BytesMessage) {
            BytesMessage message1 = (BytesMessage)message;
            byte[] bytes = new byte[(int)message1.getBodyLength()];
            message1.readBytes(bytes);
            return bytes;
        }
        if (message instanceof ObjectMessage) {
            return ((ObjectMessage)message).getObject();
        }
        if (message instanceof StreamMessage) {
            StreamMessage streamMessage = (StreamMessage)message;
            return streamMessage.readObject();
        }
        return new byte[0];
    }
}

