/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet;

import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.wsdl.http.AddressType;

public final class BaseUrlHelper {
    private BaseUrlHelper() {
    }

    public static String getBaseURL(HttpServletRequest request) {
        String pathInfo;
        String reqPrefix = request.getRequestURL().toString();
        String string = pathInfo = request.getPathInfo() == null ? "" : request.getPathInfo();
        if (!"/".equals(pathInfo) || reqPrefix.endsWith("/")) {
            StringBuilder sb = new StringBuilder();
            URI uri = URI.create(reqPrefix);
            sb.append(uri.getScheme()).append("://").append(uri.getRawAuthority());
            sb.append(request.getContextPath()).append(request.getServletPath());
            reqPrefix = sb.toString();
        }
        return reqPrefix;
    }

    public static void setAddress(AbstractDestination dest, String absAddress) {
        dest.getEndpointInfo().setAddress(absAddress);
        if (dest.getEndpointInfo().getExtensor(AddressType.class) != null) {
            ((AddressType)dest.getEndpointInfo().getExtensor(AddressType.class)).setLocation(absAddress);
        }
    }
}

