/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_undertow.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.RequestLimitingHandler;
import org.apache.cxf.transport.http_undertow.CXFUndertowHttpHandler;

public class CxfRequestLimitingHandler
implements CXFUndertowHttpHandler {
    private HttpHandler next;
    private RequestLimitingHandler requestLimitingHandler;
    private int maximumConcurrentRequests;
    private int queueSize;

    public CxfRequestLimitingHandler(int maximumConcurrentRequests, int queueSize) {
        this.setMaximumConcurrentRequests(maximumConcurrentRequests);
        this.setQueueSize(queueSize);
    }

    public CxfRequestLimitingHandler() {
        this.setMaximumConcurrentRequests(1);
        this.setQueueSize(1);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.requestLimitingHandler == null) {
            this.buildLogHandler();
        }
        this.requestLimitingHandler.handleRequest(exchange);
    }

    @Override
    public void setNext(HttpHandler nextHandler) {
        this.next = nextHandler;
    }

    private void buildLogHandler() {
        HttpHandler handler = this.next;
        this.requestLimitingHandler = new RequestLimitingHandler(this.getMaximumConcurrentRequests(), this.getQueueSize(), handler);
    }

    public int getMaximumConcurrentRequests() {
        return this.maximumConcurrentRequests;
    }

    public void setMaximumConcurrentRequests(int maximumConcurrentRequests) {
        this.maximumConcurrentRequests = maximumConcurrentRequests;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }
}

