/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger.openapi;

import io.swagger.util.Json;
import java.io.IOException;
import java.net.URI;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.swagger.openapi.OpenApiConfiguration;
import org.apache.cxf.jaxrs.swagger.openapi.SwaggerToOpenApiConversionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

@Provider
@PreMatching
public final class SwaggerToOpenApiConversionFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final String SWAGGER_PATH = "swagger.json";
    private static final String OPEN_API_PATH = "openapi.json";
    private static final String OPEN_API_PROPERTY = "openapi";
    private OpenApiConfiguration openApiConfig;
    private String openApiJsonPath = "openapi.json";

    public void filter(ContainerRequestContext reqCtx) throws IOException {
        String path = reqCtx.getUriInfo().getPath();
        if (path.endsWith(this.openApiJsonPath)) {
            reqCtx.setRequestUri(URI.create(SWAGGER_PATH));
            reqCtx.setProperty(OPEN_API_PROPERTY, (Object)Boolean.TRUE);
        }
    }

    public void filter(ContainerRequestContext reqCtx, ContainerResponseContext respCtx) throws IOException {
        if (Boolean.TRUE == reqCtx.getProperty(OPEN_API_PROPERTY)) {
            Object entity = respCtx.getEntity();
            String swaggerJson = entity instanceof String ? (String)entity : Json.pretty((Object)entity);
            String openApiJson = SwaggerToOpenApiConversionUtils.getOpenApiFromSwaggerJson(this.createMessageContext(), swaggerJson, this.openApiConfig);
            respCtx.setEntity((Object)openApiJson);
        }
    }

    private MessageContext createMessageContext() {
        return (MessageContext)JAXRSUtils.createContextValue((Message)JAXRSUtils.getCurrentMessage(), null, MessageContext.class);
    }

    public void setOpenApiConfig(OpenApiConfiguration openApiConfig) {
        this.openApiConfig = openApiConfig;
    }

    public void setOpenApiJsonPath(String openApiJsonPath) {
        this.openApiJsonPath = openApiJsonPath;
    }
}

