/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger;

import java.lang.annotation.Annotation;
import java.net.URL;
import org.apache.cxf.jaxrs.swagger.SwaggerUiResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class OsgiSwaggerUiResolver
extends SwaggerUiResolver {
    private static final String DEFAULT_COORDINATES = "org.webjars/swagger-ui";
    private static final String[] DEFAULT_LOCATIONS = new String[]{"mvn:org.webjars/swagger-ui/", "wrap:mvn:org.webjars/swagger-ui/"};
    private final Class<? extends Annotation> annotationBundle;

    public OsgiSwaggerUiResolver(Class<? extends Annotation> annotationBundle) throws Exception {
        super(annotationBundle.getClassLoader());
        Class.forName("org.osgi.framework.FrameworkUtil");
        this.annotationBundle = annotationBundle;
    }

    @Override
    public String findSwaggerUiRootInternal(String swaggerUiMavenGroupAndArtifact, String swaggerUiVersion) {
        try {
            String[] stringArray;
            Bundle bundle = FrameworkUtil.getBundle(this.annotationBundle);
            if (bundle == null) {
                return null;
            }
            if (bundle.getState() != 32) {
                bundle.start();
            }
            if (swaggerUiMavenGroupAndArtifact == null) {
                stringArray = DEFAULT_LOCATIONS;
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "mvn:" + swaggerUiMavenGroupAndArtifact + "/";
                stringArray = stringArray2;
                stringArray2[1] = "wrap:mvn:" + swaggerUiMavenGroupAndArtifact + "/";
            }
            String[] locations = stringArray;
            for (Bundle b : bundle.getBundleContext().getBundles()) {
                String rootCandidate;
                String location = b.getLocation();
                for (String pattern : locations) {
                    if (swaggerUiVersion != null) {
                        if (!location.equals(pattern + swaggerUiVersion)) continue;
                        return this.getSwaggerUiRoot(b, swaggerUiVersion);
                    }
                    if (!location.startsWith(pattern)) continue;
                    int dollarIndex = location.indexOf("$");
                    swaggerUiVersion = location.substring(pattern.length(), dollarIndex > pattern.length() ? dollarIndex : location.length());
                    return this.getSwaggerUiRoot(b, swaggerUiVersion);
                }
                if (swaggerUiMavenGroupAndArtifact != null || (rootCandidate = this.getSwaggerUiRoot(b, swaggerUiVersion)) == null) continue;
                return rootCandidate;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private String getSwaggerUiRoot(Bundle b, String swaggerUiVersion) {
        URL entry;
        if (swaggerUiVersion == null) {
            swaggerUiVersion = b.getVersion().toString();
        }
        if ((entry = b.getEntry("META-INF/resources/webjars/swagger-ui/" + swaggerUiVersion)) != null) {
            return entry.toString() + "/";
        }
        return null;
    }
}

