/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.jaxrs.swagger.SwaggerUiResourceFilter;
import org.apache.cxf.jaxrs.swagger.SwaggerUiResourceLocator;
import org.apache.cxf.jaxrs.swagger.SwaggerUiService;
import org.apache.cxf.jaxrs.swagger.SwaggerUiServiceFilter;
import org.apache.cxf.jaxrs.swagger.ui.SwaggerUiConfig;

public interface SwaggerUiSupport {
    public static final String SUPPORT_UI_PROPERTY = "support.swagger.ui";

    default public Registration getSwaggerUi(Bus bus, Properties swaggerProps, boolean runAsFilter) {
        String swaggerUiRoot;
        Registration registration = new Registration();
        if (this.checkSupportSwaggerUiProp(swaggerProps) && (swaggerUiRoot = this.findSwaggerUiRoot()) != null) {
            SwaggerUiResourceLocator locator = new SwaggerUiResourceLocator(swaggerUiRoot);
            SwaggerUiService swaggerUiService = new SwaggerUiService(locator, this.getSwaggerUiMediaTypes());
            swaggerUiService.setConfig(this.getSwaggerUiConfig());
            if (!runAsFilter) {
                registration.resources.add(swaggerUiService);
            } else {
                registration.providers.add(new SwaggerUiServiceFilter(swaggerUiService));
            }
            registration.providers.add(new SwaggerUiResourceFilter(locator));
            bus.setProperty("swagger.service.ui.available", (Object)"true");
        }
        return registration;
    }

    default public boolean checkSupportSwaggerUiProp(Properties props) {
        Boolean theSupportSwaggerUI = this.isSupportSwaggerUi();
        if (theSupportSwaggerUI == null && props != null && props.containsKey(SUPPORT_UI_PROPERTY)) {
            theSupportSwaggerUI = PropertyUtils.isTrue((Object)props.get(SUPPORT_UI_PROPERTY));
        }
        if (theSupportSwaggerUI == null) {
            theSupportSwaggerUI = true;
        }
        return theSupportSwaggerUI;
    }

    public Boolean isSupportSwaggerUi();

    public String findSwaggerUiRoot();

    public Map<String, String> getSwaggerUiMediaTypes();

    public SwaggerUiConfig getSwaggerUiConfig();

    public static class Registration {
        private final List<Object> resources = new ArrayList<Object>();
        private final List<Object> providers = new ArrayList<Object>();

        public List<Object> getResources() {
            return this.resources;
        }

        public List<Object> getProviders() {
            return this.providers;
        }
    }
}

