/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.saml.AbstractSamlInHandler;
import org.apache.cxf.rs.security.saml.DeflateEncoderDecoder;

public abstract class AbstractSamlBase64InHandler
extends AbstractSamlInHandler {
    private boolean useDeflateEncoding = true;

    public void setUseDeflateEncoding(boolean deflate) {
        this.useDeflateEncoding = deflate;
    }

    public boolean useDeflateEncoding() {
        return this.useDeflateEncoding;
    }

    protected void handleToken(Message message, String assertion) {
        if (assertion == null) {
            this.throwFault("SAML assertion is not available", null);
        }
        try {
            byte[] deflatedToken = Base64Utility.decode((String)assertion);
            InputStream is = this.useDeflateEncoding() ? new DeflateEncoderDecoder().inflateToken(deflatedToken) : new ByteArrayInputStream(deflatedToken);
            this.validateToken(message, is);
        }
        catch (Base64Exception ex) {
            this.throwFault("Base64 decoding has failed", (Exception)((Object)ex));
        }
        catch (DataFormatException ex) {
            this.throwFault("Encoded assertion can not be inflated", ex);
        }
    }
}

