/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import javax.annotation.PreDestroy;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.cxf.Bus;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.saml.DeflateEncoderDecoder;
import org.apache.cxf.rs.security.saml.sso.AbstractSSOSpHandler;
import org.apache.cxf.rs.security.saml.sso.EHCacheTokenReplayCache;
import org.apache.cxf.rs.security.saml.sso.SAMLProtocolResponseValidator;
import org.apache.cxf.rs.security.saml.sso.SAMLSSOResponseValidator;
import org.apache.cxf.rs.security.saml.sso.SSOValidatorResponse;
import org.apache.cxf.rs.security.saml.sso.TokenReplayCache;
import org.apache.cxf.rs.security.saml.sso.state.RequestState;
import org.apache.cxf.rs.security.saml.sso.state.ResponseState;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.apache.wss4j.common.util.DOM2Writer;
import org.opensaml.core.xml.XMLObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractRequestAssertionConsumerHandler
extends AbstractSSOSpHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractRequestAssertionConsumerHandler.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(AbstractRequestAssertionConsumerHandler.class);
    private boolean supportDeflateEncoding = true;
    private boolean supportBase64Encoding = true;
    private boolean enforceAssertionsSigned = true;
    private boolean enforceKnownIssuer = true;
    private boolean keyInfoMustBeAvailable = true;
    private boolean checkClientAddress = true;
    private boolean enforceResponseSigned;
    private TokenReplayCache<String> replayCache;
    private MessageContext messageContext;
    private String applicationURL;
    private boolean parseApplicationURLFromRelayState;
    private String assertionConsumerServiceAddress;

    @Context
    public void setMessageContext(MessageContext mc) {
        this.messageContext = mc;
    }

    public void setSupportDeflateEncoding(boolean deflate) {
        this.supportDeflateEncoding = deflate;
    }

    public boolean isSupportDeflateEncoding() {
        return this.supportDeflateEncoding;
    }

    public void setReplayCache(TokenReplayCache<String> replayCache) {
        this.replayCache = replayCache;
    }

    public TokenReplayCache<String> getReplayCache() throws Exception {
        if (this.replayCache == null) {
            Bus bus = (Bus)this.messageContext.getContextualProperty((Object)Bus.class.getName());
            this.replayCache = new EHCacheTokenReplayCache(bus);
        }
        return this.replayCache;
    }

    public void setEnforceAssertionsSigned(boolean enforceAssertionsSigned) {
        this.enforceAssertionsSigned = enforceAssertionsSigned;
    }

    public void setEnforceKnownIssuer(boolean enforceKnownIssuer) {
        this.enforceKnownIssuer = enforceKnownIssuer;
    }

    public void setSupportBase64Encoding(boolean supportBase64Encoding) {
        this.supportBase64Encoding = supportBase64Encoding;
    }

    public boolean isSupportBase64Encoding() {
        return this.supportBase64Encoding;
    }

    @Override
    @PreDestroy
    public void close() {
        if (this.replayCache != null) {
            try {
                this.replayCache.close();
            }
            catch (IOException ex) {
                LOG.warning("Replay cache can not be closed: " + ex.getMessage());
            }
        }
        super.close();
    }

    protected Response doProcessSamlResponse(String encodedSamlResponse, String relayState, boolean postBinding) {
        RequestState requestState = this.processRelayState(relayState);
        String contextCookie = this.createSecurityContext(requestState, encodedSamlResponse, relayState, postBinding);
        URI targetURI = this.getTargetURI(requestState.getTargetAddress());
        return Response.seeOther((URI)targetURI).header("Set-Cookie", (Object)contextCookie).build();
    }

    private URI getTargetURI(String targetAddress) {
        if (targetAddress != null) {
            try {
                return URI.create(targetAddress);
            }
            catch (IllegalArgumentException ex) {
                this.reportError("INVALID_TARGET_URI");
            }
        } else {
            this.reportError("MISSING_TARGET_URI");
        }
        throw ExceptionUtils.toBadRequestException(null, null);
    }

    protected String createSecurityContext(RequestState requestState, String encodedSamlResponse, String relayState, boolean postBinding) {
        org.opensaml.saml.saml2.core.Response samlResponse = this.readSAMLResponse(postBinding, encodedSamlResponse);
        this.validateSamlResponseProtocol(samlResponse);
        SSOValidatorResponse validatorResponse = this.validateSamlSSOResponse(postBinding, samlResponse, requestState);
        String securityContextKey = UUID.randomUUID().toString();
        long currentTime = System.currentTimeMillis();
        Instant notOnOrAfter = validatorResponse.getSessionNotOnOrAfter();
        long expiresAt = 0L;
        expiresAt = notOnOrAfter != null ? notOnOrAfter.toEpochMilli() : currentTime + this.getStateTimeToLive();
        ResponseState responseState = new ResponseState(validatorResponse.getAssertion(), relayState, requestState.getWebAppContext(), requestState.getWebAppDomain(), currentTime, expiresAt);
        this.getStateProvider().setResponseState(securityContextKey, responseState);
        return this.createCookie("org.apache.cxf.websso.context", securityContextKey, requestState.getWebAppContext(), requestState.getWebAppDomain());
    }

    protected RequestState processRelayState(String relayState) {
        if (this.isSupportUnsolicited()) {
            String urlToForwardTo = this.applicationURL;
            if (relayState != null && relayState.getBytes().length > 0 && relayState.getBytes().length < 80) {
                RequestState requestState = this.getStateProvider().removeRequestState(relayState);
                if (requestState != null && !this.isStateExpired(requestState.getCreatedAt(), requestState.getTimeToLive())) {
                    return requestState;
                }
                if (this.parseApplicationURLFromRelayState) {
                    urlToForwardTo = relayState;
                }
            }
            Instant now = Instant.now();
            return new RequestState(urlToForwardTo, this.getIdpServiceAddress(), null, this.getIssuerId(JAXRSUtils.getCurrentMessage()), "/", null, now.toEpochMilli(), this.getStateTimeToLive());
        }
        if (relayState == null) {
            this.reportError("MISSING_RELAY_STATE");
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        if (relayState.getBytes().length == 0 || relayState.getBytes().length > 80) {
            this.reportError("INVALID_RELAY_STATE");
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        RequestState requestState = this.getStateProvider().removeRequestState(relayState);
        if (requestState == null) {
            this.reportError("MISSING_REQUEST_STATE");
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        if (this.isStateExpired(requestState.getCreatedAt(), requestState.getTimeToLive())) {
            this.reportError("EXPIRED_REQUEST_STATE");
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        return requestState;
    }

    private org.opensaml.saml.saml2.core.Response readSAMLResponse(boolean postBinding, String samlResponse) {
        if (StringUtils.isEmpty((String)samlResponse)) {
            this.reportError("MISSING_SAML_RESPONSE");
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        String samlResponseDecoded = samlResponse;
        ByteArrayInputStream tokenStream = null;
        if (this.isSupportBase64Encoding()) {
            try {
                byte[] deflatedToken = Base64Utility.decode((String)samlResponseDecoded);
                tokenStream = !postBinding && this.isSupportDeflateEncoding() ? new DeflateEncoderDecoder().inflateToken(deflatedToken) : new ByteArrayInputStream(deflatedToken);
            }
            catch (DataFormatException | Base64Exception ex) {
                throw ExceptionUtils.toBadRequestException((Throwable)ex, null);
            }
        } else {
            tokenStream = new ByteArrayInputStream(samlResponseDecoded.getBytes(StandardCharsets.UTF_8));
        }
        Document responseDoc = null;
        try {
            responseDoc = StaxUtils.read((Reader)new InputStreamReader((InputStream)tokenStream, StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            throw new WebApplicationException(400);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Received response: " + DOM2Writer.nodeToString((Node)responseDoc.getDocumentElement()));
        }
        XMLObject responseObject = null;
        try {
            responseObject = OpenSAMLUtil.fromDom((Element)responseDoc.getDocumentElement());
        }
        catch (WSSecurityException ex) {
            throw ExceptionUtils.toBadRequestException((Throwable)ex, null);
        }
        if (!(responseObject instanceof org.opensaml.saml.saml2.core.Response)) {
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        return (org.opensaml.saml.saml2.core.Response)responseObject;
    }

    protected void validateSamlResponseProtocol(org.opensaml.saml.saml2.core.Response samlResponse) {
        try {
            SAMLProtocolResponseValidator protocolValidator = new SAMLProtocolResponseValidator();
            protocolValidator.setKeyInfoMustBeAvailable(this.keyInfoMustBeAvailable);
            protocolValidator.validateSamlResponse(samlResponse, this.getSignatureCrypto(), this.getCallbackHandler());
        }
        catch (WSSecurityException ex) {
            LOG.log(Level.FINE, ex.getMessage(), ex);
            this.reportError("INVALID_SAML_RESPONSE");
            throw ExceptionUtils.toBadRequestException(null, null);
        }
    }

    protected SSOValidatorResponse validateSamlSSOResponse(boolean postBinding, org.opensaml.saml.saml2.core.Response samlResponse, RequestState requestState) {
        try {
            SAMLSSOResponseValidator ssoResponseValidator = new SAMLSSOResponseValidator();
            String racsAddress = this.assertionConsumerServiceAddress;
            if (racsAddress == null) {
                racsAddress = this.messageContext.getUriInfo().getAbsolutePath().toString();
            }
            ssoResponseValidator.setAssertionConsumerURL(racsAddress);
            if (this.checkClientAddress) {
                ssoResponseValidator.setClientAddress(this.messageContext.getHttpServletRequest().getRemoteAddr());
            }
            ssoResponseValidator.setIssuerIDP(requestState.getIdpServiceAddress());
            ssoResponseValidator.setRequestId(requestState.getSamlRequestId());
            ssoResponseValidator.setSpIdentifier(requestState.getIssuerId());
            ssoResponseValidator.setEnforceAssertionsSigned(this.enforceAssertionsSigned);
            ssoResponseValidator.setEnforceResponseSigned(this.enforceResponseSigned);
            ssoResponseValidator.setEnforceKnownIssuer(this.enforceKnownIssuer);
            if (postBinding) {
                ssoResponseValidator.setReplayCache(this.getReplayCache());
            }
            return ssoResponseValidator.validateSamlResponse(samlResponse, postBinding);
        }
        catch (Exception ex) {
            this.reportError("INVALID_SAML_RESPONSE");
            throw ExceptionUtils.toBadRequestException((Throwable)ex, null);
        }
    }

    protected void reportError(String code) {
        Message errorMsg = new Message(code, BUNDLE, new Object[0]);
        LOG.warning(errorMsg.toString());
    }

    public void setKeyInfoMustBeAvailable(boolean keyInfoMustBeAvailable) {
        this.keyInfoMustBeAvailable = keyInfoMustBeAvailable;
    }

    public boolean isEnforceResponseSigned() {
        return this.enforceResponseSigned;
    }

    public void setEnforceResponseSigned(boolean enforceResponseSigned) {
        this.enforceResponseSigned = enforceResponseSigned;
    }

    public String getApplicationURL() {
        return this.applicationURL;
    }

    public void setApplicationURL(String applicationURL) {
        this.applicationURL = applicationURL;
    }

    public boolean isParseApplicationURLFromRelayState() {
        return this.parseApplicationURLFromRelayState;
    }

    public void setParseApplicationURLFromRelayState(boolean parseApplicationURLFromRelayState) {
        this.parseApplicationURLFromRelayState = parseApplicationURLFromRelayState;
    }

    public String getAssertionConsumerServiceAddress() {
        return this.assertionConsumerServiceAddress;
    }

    public void setAssertionConsumerServiceAddress(String assertionConsumerServiceAddress) {
        this.assertionConsumerServiceAddress = assertionConsumerServiceAddress;
    }

    public boolean isCheckClientAddress() {
        return this.checkClientAddress;
    }

    public void setCheckClientAddress(boolean checkClientAddress) {
        this.checkClientAddress = checkClientAddress;
    }

    protected boolean isStateExpired(long stateCreatedAt, long expiresAt) {
        Instant currentTime = Instant.now();
        return expiresAt > 0L && currentTime.isAfter(Instant.ofEpochMilli(stateCreatedAt + expiresAt));
    }
}

