/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.jaxrs.ext.MessageContextImpl;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.saml.DeflateEncoderDecoder;
import org.apache.cxf.rs.security.saml.sso.AbstractServiceProviderFilter;
import org.apache.cxf.rs.security.saml.sso.SamlRequestInfo;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.apache.wss4j.common.util.DOM2Writer;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.Signature;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SamlPostBindingFilter
extends AbstractServiceProviderFilter {
    private boolean useDeflateEncoding;

    public void setUseDeflateEncoding(boolean useDeflateEncoding) {
        this.useDeflateEncoding = useDeflateEncoding;
    }

    public void filter(ContainerRequestContext context) {
        Message m = JAXRSUtils.getCurrentMessage();
        if (this.checkSecurityContext(m)) {
            return;
        }
        try {
            SamlRequestInfo info = this.createSamlRequestInfo(m);
            info.setIdpServiceAddress(this.getIdpServiceAddress());
            String contextCookie = this.createCookie("RelayState", info.getRelayState(), info.getWebAppContext(), info.getWebAppDomain());
            new MessageContextImpl(m).getHttpServletResponse().addHeader("Set-Cookie", contextCookie);
            context.abortWith(Response.ok((Object)info).type("text/html").header("Cache-Control", (Object)"no-cache, no-store").header("Pragma", (Object)"no-cache").build());
        }
        catch (Exception ex) {
            throw ExceptionUtils.toInternalServerErrorException((Throwable)ex, null);
        }
    }

    @Override
    protected String encodeAuthnRequest(Element authnRequest) throws IOException {
        String requestMessage = DOM2Writer.nodeToString((Node)authnRequest);
        byte[] deflatedBytes = null;
        if (this.useDeflateEncoding) {
            DeflateEncoderDecoder encoder = new DeflateEncoderDecoder();
            deflatedBytes = encoder.deflateToken(requestMessage.getBytes("UTF-8"));
        } else {
            deflatedBytes = requestMessage.getBytes("UTF-8");
        }
        return Base64Utility.encode((byte[])deflatedBytes);
    }

    @Override
    protected void signAuthnRequest(AuthnRequest authnRequest) throws Exception {
        Crypto crypto = this.getSignatureCrypto();
        if (crypto == null) {
            LOG.fine("No crypto instance of properties file configured for signature");
            throw ExceptionUtils.toInternalServerErrorException(null, null);
        }
        String signatureUser = this.getSignatureUsername();
        if (signatureUser == null) {
            LOG.fine("No user configured for signature");
            throw ExceptionUtils.toInternalServerErrorException(null, null);
        }
        CallbackHandler callbackHandler = this.getCallbackHandler();
        if (callbackHandler == null) {
            LOG.fine("No CallbackHandler configured to supply a password for signature");
            throw ExceptionUtils.toInternalServerErrorException(null, null);
        }
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias(signatureUser);
        X509Certificate[] issuerCerts = crypto.getX509Certificates(cryptoType);
        if (issuerCerts == null) {
            throw new Exception("No issuer certs were found to sign the request using name: " + signatureUser);
        }
        String sigAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        String pubKeyAlgo = issuerCerts[0].getPublicKey().getAlgorithm();
        LOG.fine("automatic sig algo detection: " + pubKeyAlgo);
        if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
            sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        }
        LOG.fine("Using Signature algorithm " + sigAlgo);
        WSPasswordCallback[] cb = new WSPasswordCallback[]{new WSPasswordCallback(signatureUser, 3)};
        callbackHandler.handle((Callback[])cb);
        String password = cb[0].getPassword();
        PrivateKey privateKey = crypto.getPrivateKey(signatureUser, password);
        Signature signature = OpenSAMLUtil.buildSignature();
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        signature.setSignatureAlgorithm(sigAlgo);
        BasicX509Credential signingCredential = new BasicX509Credential(issuerCerts[0], privateKey);
        signature.setSigningCredential((Credential)signingCredential);
        X509KeyInfoGeneratorFactory kiFactory = new X509KeyInfoGeneratorFactory();
        kiFactory.setEmitEntityCertificate(true);
        try {
            KeyInfo keyInfo = kiFactory.newInstance().generate((Credential)signingCredential);
            signature.setKeyInfo(keyInfo);
        }
        catch (SecurityException ex) {
            throw new Exception("Error generating KeyInfo from signing credential", ex);
        }
        AuthnRequest signableObject = authnRequest;
        signableObject.setSignature(signature);
        signableObject.releaseDOM();
        signableObject.releaseChildrenDOM(true);
    }
}

