/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.security.Key;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.xml.security.stax.impl.util.IDGenerator;
import org.apache.xml.security.utils.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MetadataWriter {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataWriter.class);
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private static final DocumentBuilderFactory DOC_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private static final XMLSignatureFactory XML_SIGNATURE_FACTORY = XMLSignatureFactory.getInstance("DOM");

    public Document getMetaData(String serviceURL, String assertionConsumerServiceURL, String logoutURL, Key signingKey, X509Certificate signingCert, boolean wantRequestsSigned) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(4096);
        OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)bout, "UTF-8");
        XMLStreamWriter writer = XML_OUTPUT_FACTORY.createXMLStreamWriter(streamWriter);
        writer.writeStartDocument("UTF-8", "1.0");
        String referenceID = IDGenerator.generateID((String)"_");
        writer.writeStartElement("md", "EntityDescriptor", "urn:oasis:names:tc:SAML:2.0:metadata");
        writer.writeAttribute("ID", referenceID);
        writer.writeAttribute("entityID", serviceURL);
        writer.writeNamespace("md", "urn:oasis:names:tc:SAML:2.0:metadata");
        writer.writeNamespace("wsa", "http://www.w3.org/2005/08/addressing");
        writer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.writeSAMLMetadata(writer, assertionConsumerServiceURL, logoutURL, signingCert, wantRequestsSigned);
        writer.writeEndElement();
        writer.writeEndDocument();
        ((Writer)streamWriter).flush();
        bout.flush();
        if (LOG.isDebugEnabled()) {
            String out = new String(bout.toByteArray());
            LOG.debug("***************** unsigned ****************");
            LOG.debug(out);
            LOG.debug("***************** unsigned ****************");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(bout.toByteArray());
        if (signingKey != null) {
            return MetadataWriter.signMetaInfo(signingCert, signingKey, is, referenceID);
        }
        return DOC_BUILDER_FACTORY.newDocumentBuilder().parse(is);
    }

    private void writeSAMLMetadata(XMLStreamWriter writer, String assertionConsumerServiceURL, String logoutURL, X509Certificate signingCert, boolean wantRequestsSigned) throws XMLStreamException, MalformedURLException, CertificateEncodingException {
        writer.writeStartElement("md", "SPSSODescriptor", "urn:oasis:names:tc:SAML:2.0:metadata");
        writer.writeAttribute("AuthnRequestsSigned", Boolean.toString(wantRequestsSigned));
        writer.writeAttribute("WantAssertionsSigned", "true");
        writer.writeAttribute("protocolSupportEnumeration", "urn:oasis:names:tc:SAML:2.0:protocol");
        if (logoutURL != null) {
            writer.writeStartElement("md", "SingleLogoutService", "urn:oasis:names:tc:SAML:2.0:metadata");
            writer.writeAttribute("Location", logoutURL);
            writer.writeAttribute("Binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            writer.writeEndElement();
        }
        writer.writeStartElement("md", "AssertionConsumerService", "urn:oasis:names:tc:SAML:2.0:metadata");
        writer.writeAttribute("Location", assertionConsumerServiceURL);
        writer.writeAttribute("index", "0");
        writer.writeAttribute("isDefault", "true");
        writer.writeAttribute("Binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        writer.writeEndElement();
        writer.writeStartElement("md", "AssertionConsumerService", "urn:oasis:names:tc:SAML:2.0:metadata");
        writer.writeAttribute("Location", assertionConsumerServiceURL);
        writer.writeAttribute("index", "1");
        writer.writeAttribute("Binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-REDIRECT");
        writer.writeEndElement();
        if (signingCert != null) {
            writer.writeStartElement("md", "KeyDescriptor", "urn:oasis:names:tc:SAML:2.0:metadata");
            writer.writeAttribute("use", "signing");
            writer.writeStartElement("ds", "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
            writer.writeNamespace("ds", "http://www.w3.org/2000/09/xmldsig#");
            writer.writeStartElement("ds", "X509Data", "http://www.w3.org/2000/09/xmldsig#");
            writer.writeStartElement("ds", "X509Certificate", "http://www.w3.org/2000/09/xmldsig#");
            byte[] data = signingCert.getEncoded();
            String encodedCertificate = Base64.encode((byte[])data);
            writer.writeCharacters(encodedCertificate);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private static Document signMetaInfo(X509Certificate signingCert, Key signingKey, InputStream metaInfo, String referenceID) throws Exception {
        String signatureMethod = null;
        if ("SHA1withDSA".equals(signingCert.getSigAlgName())) {
            signatureMethod = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        } else if ("SHA1withRSA".equals(signingCert.getSigAlgName())) {
            signatureMethod = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        } else if ("SHA256withRSA".equals(signingCert.getSigAlgName())) {
            signatureMethod = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        } else {
            LOG.error("Unsupported signature method: " + signingCert.getSigAlgName());
            throw new RuntimeException("Unsupported signature method: " + signingCert.getSigAlgName());
        }
        ArrayList<Transform> transformList = new ArrayList<Transform>();
        transformList.add(XML_SIGNATURE_FACTORY.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
        transformList.add(XML_SIGNATURE_FACTORY.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null));
        Reference ref = XML_SIGNATURE_FACTORY.newReference("#" + referenceID, XML_SIGNATURE_FACTORY.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), transformList, null, null);
        SignedInfo si = XML_SIGNATURE_FACTORY.newSignedInfo(XML_SIGNATURE_FACTORY.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null), XML_SIGNATURE_FACTORY.newSignatureMethod(signatureMethod, null), Collections.singletonList(ref));
        KeyInfoFactory kif = XML_SIGNATURE_FACTORY.getKeyInfoFactory();
        ArrayList<Object> x509Content = new ArrayList<Object>();
        x509Content.add(signingCert.getSubjectX500Principal().getName());
        x509Content.add(signingCert);
        X509Data xd = kif.newX509Data(x509Content);
        KeyInfo ki = kif.newKeyInfo(Collections.singletonList(xd));
        Document doc = DOC_BUILDER_FACTORY.newDocumentBuilder().parse(metaInfo);
        DOMSignContext dsc = new DOMSignContext(signingKey, (Node)doc.getDocumentElement());
        dsc.setIdAttributeNS(doc.getDocumentElement(), null, "ID");
        dsc.setNextSibling(doc.getDocumentElement().getFirstChild());
        XMLSignature signature = XML_SIGNATURE_FACTORY.newXMLSignature(si, ki);
        signature.sign(dsc);
        return doc;
    }

    static {
        DOC_BUILDER_FACTORY.setNamespaceAware(true);
    }
}

