/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.client;

import java.net.URI;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.oauth2.client.BearerAuthSupplier;
import org.apache.cxf.rs.security.oauth2.client.OAuthClientUtils;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeGrant;
import org.apache.cxf.transport.http.auth.HttpAuthSupplier;

public class CodeAuthSupplier
implements HttpAuthSupplier {
    private volatile String code;
    private BearerAuthSupplier tokenSupplier = new BearerAuthSupplier();

    public boolean requiresRequestCaching() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAuthorization(AuthorizationPolicy authPolicy, URI currentURI, Message message, String fullHeader) {
        if (this.code != null) {
            BearerAuthSupplier bearerAuthSupplier = this.tokenSupplier;
            synchronized (bearerAuthSupplier) {
                if (this.tokenSupplier.getClientAccessToken().getTokenKey() == null) {
                    WebClient wc = this.tokenSupplier.createAccessTokenServiceClient();
                    ClientAccessToken at = OAuthClientUtils.getAccessToken(wc, this.tokenSupplier.getConsumer(), new AuthorizationCodeGrant(this.code));
                    this.code = null;
                    this.tokenSupplier.setClientAccessToken(at);
                }
            }
        }
        return this.tokenSupplier.getAuthorization(authPolicy, currentURI, message, fullHeader);
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setRefreshEarly(boolean refreshEarly) {
        this.tokenSupplier.setRefreshEarly(refreshEarly);
    }

    public void setAccessTokenServiceUri(String uri) {
        this.tokenSupplier.setAccessTokenServiceUri(uri);
    }

    public void setConsumer(OAuthClientUtils.Consumer consumer) {
        this.tokenSupplier.setConsumer(consumer);
    }
}

