/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.client;

import java.net.URI;
import java.util.Collections;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.oauth2.client.AbstractAuthSupplier;
import org.apache.cxf.rs.security.oauth2.client.OAuthClientUtils;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.provider.OAuthJSONProvider;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.apache.cxf.transport.http.auth.HttpAuthSupplier;

public class BearerAuthSupplier
extends AbstractAuthSupplier
implements HttpAuthSupplier {
    private OAuthClientUtils.Consumer consumer;
    private String accessTokenServiceUri;
    private boolean refreshEarly;

    public BearerAuthSupplier() {
        super("Bearer");
    }

    public boolean requiresRequestCaching() {
        return true;
    }

    public String getAuthorization(AuthorizationPolicy authPolicy, URI currentURI, Message message, String fullHeader) {
        if (this.getClientAccessToken().getTokenKey() == null) {
            return null;
        }
        if (fullHeader == null) {
            if (this.refreshEarly) {
                this.refreshAccessTokenIfExpired(authPolicy);
            }
            return this.createAuthorizationHeader();
        }
        if (this.refreshAccessToken(authPolicy)) {
            return this.createAuthorizationHeader();
        }
        return null;
    }

    private void refreshAccessTokenIfExpired(AuthorizationPolicy authPolicy) {
        ClientAccessToken at = this.getClientAccessToken();
        if (OAuthUtils.isExpired(at.getIssuedAt(), at.getExpiresIn())) {
            this.refreshAccessToken(authPolicy);
        }
    }

    private boolean refreshAccessToken(AuthorizationPolicy authPolicy) {
        ClientAccessToken at = this.getClientAccessToken();
        if (at.getRefreshToken() == null) {
            return false;
        }
        OAuthClientUtils.Consumer theConsumer = this.consumer;
        if (theConsumer == null && authPolicy != null && authPolicy.getUserName() != null && authPolicy.getPassword() != null) {
            theConsumer = new OAuthClientUtils.Consumer(authPolicy.getUserName(), authPolicy.getPassword());
            return false;
        }
        if (theConsumer == null) {
            return false;
        }
        WebClient accessTokenService = this.createAccessTokenServiceClient();
        this.setClientAccessToken(OAuthClientUtils.refreshAccessToken(accessTokenService, theConsumer, at));
        return true;
    }

    WebClient createAccessTokenServiceClient() {
        return WebClient.create((String)this.accessTokenServiceUri, Collections.singletonList(new OAuthJSONProvider()));
    }

    public void setRefreshToken(String refreshToken) {
        this.getClientAccessToken().setRefreshToken(refreshToken);
    }

    public void setAccessTokenServiceUri(String uri) {
        this.accessTokenServiceUri = uri;
    }

    public void setConsumer(OAuthClientUtils.Consumer c) {
        this.consumer = c;
    }

    public OAuthClientUtils.Consumer getConsumer() {
        return this.consumer;
    }

    public void setRefreshEarly(boolean refreshEarly) {
        this.refreshEarly = refreshEarly;
    }
}

