/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth.provider;

import java.io.IOException;
import java.net.URISyntaxException;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.SimpleOAuthValidator;
import org.apache.cxf.rs.security.oauth.data.Token;
import org.apache.cxf.rs.security.oauth.provider.OAuthDataProvider;

public class DefaultOAuthValidator
extends SimpleOAuthValidator {
    public void checkSingleParameter(OAuthMessage message) throws OAuthException, IOException, URISyntaxException {
        super.checkSingleParameters(message);
    }

    public void validateToken(Token token, OAuthDataProvider provider) throws OAuthProblemException {
        if (token == null) {
            throw new OAuthProblemException("token_rejected");
        }
        long issuedAt = token.getIssuedAt();
        long lifetime = token.getLifetime();
        if (lifetime != -1L && issuedAt + lifetime < System.currentTimeMillis() / 1000L) {
            provider.removeToken(token);
            throw new OAuthProblemException("token_expired");
        }
    }
}

